/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.plugins.pdftest.AbstractPdfFilter;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFBookmark;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import java.util.Iterator;

public class PdfToBookmarksFilter
extends AbstractPdfFilter {
    protected void doFilter(PDFPage pdfPage) {
        String bookmarks = this.extractBookmarkAsString(pdfPage);
        ContextHelper.defineAsCurrentResponse(this.getContext(), bookmarks, "text/plain", "http:" + this.getClass().getName());
    }

    private String extractBookmarkAsString(PDFPage pdfPage) {
        StringBuffer result = new StringBuffer();
        Iterator iter = pdfPage.getBookmarks().iterator();
        while (iter.hasNext()) {
            PDFBookmark bookmark = (PDFBookmark)iter.next();
            if (bookmark.getParent() != null) continue;
            PdfToBookmarksFilter.extractBookmarkAsString(result, bookmark, "");
        }
        return result.toString();
    }

    private static void extractBookmarkAsString(StringBuffer result, PDFBookmark bookmark, String indentation) {
        result.append(indentation);
        result.append(bookmark.getTitle());
        result.append("\n");
        Iterator iter = bookmark.getchildren().iterator();
        while (iter.hasNext()) {
            PDFBookmark child = (PDFBookmark)iter.next();
            PdfToBookmarksFilter.extractBookmarkAsString(result, child, indentation + "    ");
        }
    }
}

