/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.exceltest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.exceltest.AbstractExcelSheetStep;
import com.canoo.webtest.plugins.exceltest.ExcelCellUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.CellReference;

public class ExcelFindRow
extends AbstractExcelSheetStep {
    private String fText;
    private String fPropertyName;
    private String fPropertyType;
    private String fStartRow = "1";
    private String fCol;

    public void setStartRow(String index) {
        this.fStartRow = index;
    }

    public String getStartRow() {
        return this.fStartRow;
    }

    public void setCol(String index) {
        this.fCol = index;
    }

    public String getCol() {
        return this.fCol;
    }

    public void setProperty(String name) {
        this.fPropertyName = name;
    }

    public String getProperty() {
        return this.fPropertyName;
    }

    public void setPropertyType(String type) {
        this.fPropertyType = type;
    }

    public String getPropertyType() {
        return this.fPropertyType;
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.fText = text;
    }

    protected boolean verifyText(String actualValue) {
        return this.verifyStrings(this.getText(), actualValue);
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getText(), "text");
        this.nullParamCheck(this.getProperty(), "property");
        this.nullParamCheck(this.getCol(), "col");
        this.optionalIntegerParamCheck(this.getStartRow(), "startRow", true);
    }

    public void doExecute() {
        CellReference cellReference = ExcelCellUtils.getCellReference(this, null, this.getStartRow(), this.getCol());
        HSSFSheet excelSheet = this.getExcelSheet();
        for (int row = cellReference.getRow(); row <= excelSheet.getLastRowNum(); ++row) {
            HSSFCell excelCellAt = ExcelCellUtils.getExcelCellAt(this, row, cellReference.getCol());
            if (!this.verifyText(ExcelCellUtils.getCellValueAt(excelCellAt))) continue;
            this.setWebtestProperty(this.getProperty(), String.valueOf(row + 1), this.getPropertyType());
            return;
        }
        throw new StepFailedException("No cells were found matching '" + this.getText() + "' starting from " + cellReference, this);
    }
}

