/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.exceltest;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.plugins.exceltest.AbstractExcelSheetStep;
import com.canoo.webtest.steps.Step;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.util.CellReference;

public class ExcelCellUtils {
    private static final Logger LOG = Logger.getLogger((Class)ExcelCellUtils.class);
    public static final int TWELVE_POINT_FIVE_GRAY = 17;
    public static final int SIX_POINT_TWO_FIVE_GRAY = 18;

    public static HSSFCell getExcelCellAt(AbstractExcelSheetStep step, int row, short col) {
        if (row == -1) {
            return null;
        }
        HSSFRow excelRow = step.getExcelSheet().getRow(row);
        if (excelRow == null) {
            return null;
        }
        return excelRow.getCell(col);
    }

    public static String getCellValueAt(HSSFCell cell) {
        if (null == cell) {
            return "";
        }
        switch (cell.getCellType()) {
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 0: {
                return ExcelCellUtils.asStringTrimInts(cell.getNumericCellValue());
            }
            case 3: {
                return "";
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 2: {
                return cell.getCellFormula();
            }
            case 5: {
                return "Error Code " + String.valueOf(cell.getErrorCellValue() & 0xFF);
            }
        }
        LOG.warn((Object)("Cell Type not supported: " + cell.getCellType()));
        return "";
    }

    private static String asStringTrimInts(double value) {
        if (value == (double)((int)value)) {
            return String.valueOf((int)value);
        }
        return String.valueOf(value);
    }

    public static CellReference getCellReference(Step step, String cell, String rowStr, String colStr) {
        block6: {
            if (cell != null) {
                return ExcelCellUtils.getCellReference(step, cell);
            }
            try {
                block7: {
                    int row = Integer.parseInt(rowStr);
                    if (row <= 0) break block6;
                    try {
                        short col = Short.parseShort(colStr);
                        if (col > 0) {
                            return new CellReference(row - 1, col - 1);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!colStr.matches("[A-Z]+")) break block7;
                        return new CellReference(colStr + rowStr);
                    }
                }
                throw new StepExecutionException("Can't parse '" + colStr + "' as a column reference (eg. 'A' or '1')", step);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        throw new StepExecutionException("Can't parse '" + rowStr + "' as a integer row reference.", step);
    }

    public static CellReference getCellReference(Step step, String cell) {
        if (!cell.matches("[A-Z]+[0-9]+")) {
            throw new StepExecutionException("Invalid cell reference: " + cell, step);
        }
        return new CellReference(cell);
    }

    static String getCellType(int cellType) {
        switch (cellType) {
            case 3: {
                return "blank";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 2: {
                return "formula";
            }
            case 0: {
                return "numeric";
            }
            case 1: {
                return "string";
            }
        }
        return "unknown";
    }

    public static String getAlignmentString(short alignment) {
        switch (alignment) {
            case 2: {
                return "center";
            }
            case 6: {
                return "center-selection";
            }
            case 4: {
                return "fill";
            }
            case 0: {
                return "general";
            }
            case 5: {
                return "justify";
            }
            case 1: {
                return "left";
            }
            case 3: {
                return "right";
            }
        }
        return "unknown";
    }

    public static String getVerticalAlignmentString(short verticalAlignment) {
        switch (verticalAlignment) {
            case 2: {
                return "bottom";
            }
            case 1: {
                return "center";
            }
            case 3: {
                return "justify";
            }
            case 0: {
                return "top";
            }
        }
        return "unknown";
    }

    public static String getFillPattern(short fillPattern) {
        switch (fillPattern) {
            case 0: {
                return "none";
            }
            case 1: {
                return "solid";
            }
            case 2: {
                return "50% gray";
            }
            case 3: {
                return "75% gray";
            }
            case 4: {
                return "25% gray";
            }
            case 5: {
                return "horizontal stripe";
            }
            case 6: {
                return "vertical stripe";
            }
            case 7: {
                return "reverse diagonal stripe";
            }
            case 8: {
                return "diagonal stripe";
            }
            case 9: {
                return "diagonal crosshatch";
            }
            case 10: {
                return "thick diagonal crosshatch";
            }
            case 11: {
                return "thin horizontal stripe";
            }
            case 12: {
                return "thin vertical stripe";
            }
            case 13: {
                return "thin reverse diagonal stripe";
            }
            case 14: {
                return "thin diagonal stripe";
            }
            case 15: {
                return "thin horizontal crosshatch";
            }
            case 16: {
                return "thin diagonal crosshatch";
            }
            case 17: {
                return "12.5% gray";
            }
            case 18: {
                return "6.25% gray";
            }
        }
        return "unknown";
    }

    public static String getBorder(short border) {
        switch (border) {
            case 9: {
                return "dash dot";
            }
            case 11: {
                return "dash dot dot";
            }
            case 3: {
                return "dashed";
            }
            case 7: {
                return "dotted";
            }
            case 6: {
                return "double";
            }
            case 4: {
                return "hair";
            }
            case 2: {
                return "medium";
            }
            case 10: {
                return "medium dash dot";
            }
            case 12: {
                return "medium dash dot dot";
            }
            case 8: {
                return "medium dashed";
            }
            case 0: {
                return "none";
            }
            case 13: {
                return "slanted dash dot";
            }
            case 5: {
                return "thick";
            }
            case 1: {
                return "thin";
            }
        }
        return "unknown";
    }
}

