/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.exceltest;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.plugins.exceltest.RetryWithCapsPOIFSFileSystem;
import com.canoo.webtest.steps.Step;
import com.gargoylesoftware.htmlunit.Page;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public abstract class AbstractExcelStep
extends Step {
    private static final Logger LOG = Logger.getLogger((Class)AbstractExcelStep.class);
    private static final Map sMapWorkbooks = new WeakHashMap();
    protected static final String KEY_CURRENT_SHEET = AbstractExcelStep.class.getName() + "#CurrentSheet";

    protected AbstractExcelStep() {
    }

    protected HSSFWorkbook getExcelWorkbook() {
        Page currentPage = this.getContext().getCurrentResponse();
        HSSFWorkbook workbook = (HSSFWorkbook)sMapWorkbooks.get(currentPage);
        if (workbook == null) {
            workbook = this.createWorkbook(currentPage);
            sMapWorkbooks.put(currentPage, workbook);
        }
        return workbook;
    }

    private HSSFWorkbook createWorkbook(Page currentPage) {
        HSSFWorkbook hSSFWorkbook;
        InputStream is = null;
        try {
            this.getContext().put(KEY_CURRENT_SHEET, null);
            is = currentPage.getWebResponse().getContentAsStream();
            RetryWithCapsPOIFSFileSystem excelFile = new RetryWithCapsPOIFSFileSystem(is);
            hSSFWorkbook = new HSSFWorkbook((POIFSFileSystem)excelFile);
        }
        catch (Exception e) {
            try {
                String message = "Could not open Excel file.";
                LOG.debug((Object)"Could not open Excel file.", (Throwable)e);
                throw new StepExecutionException("Could not open Excel file.", this, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return hSSFWorkbook;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullResponseCheck();
        Page currentResponse = this.getContext().getCurrentResponse();
        String contentType = currentResponse.getWebResponse().getContentType();
        if (!"application/vnd.ms-excel".equals(contentType)) {
            throw new StepExecutionException("File does not have correct content type (not a '.xls' file?): " + currentResponse.getWebResponse().getContentType(), this);
        }
    }

    protected boolean verifyStrings(String expectedValue, String actualValue) {
        boolean regex = false;
        String newExpectedValue = expectedValue;
        if (expectedValue != null && expectedValue.length() >= 2 && expectedValue.charAt(0) == '/' && expectedValue.charAt(expectedValue.length() - 1) == '/') {
            regex = true;
            newExpectedValue = expectedValue.substring(1, expectedValue.length() - 1);
        }
        return AbstractExcelStep.getVerifier(regex).verifyStrings(newExpectedValue, actualValue);
    }
}

