/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.plugins.emailtest.AbstractMessageStoreStep;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.log4j.Logger;

public class EmailStorePartCount
extends AbstractMessageStoreStep {
    private static final Logger LOG = Logger.getLogger((Class)EmailStorePartCount.class);

    protected String performOperation(Message message) throws MessagingException {
        Object content;
        try {
            content = message.getContent();
        }
        catch (IOException e) {
            LOG.error((Object)"Error processing email message: ", (Throwable)e);
            throw new MessagingException("Error processing email message: " + e.getMessage());
        }
        if (content instanceof Multipart) {
            return String.valueOf(EmailStorePartCount.performMultipartMessageCount((Multipart)content));
        }
        return String.valueOf(EmailStorePartCount.performSimpleMessageCount((String)content));
    }

    private static int performMultipartMessageCount(Multipart multipart) throws MessagingException {
        return multipart.getCount();
    }

    private static int performSimpleMessageCount(String content) {
        String lineStr = "(^.*$)";
        String startUuencodeStr = "begin \\d\\d\\d .*";
        Pattern linePattern = Pattern.compile("(^.*$)", 8);
        Matcher matcher = linePattern.matcher(content);
        int count = 0;
        while (matcher.find()) {
            String line = matcher.group(0);
            if (!line.matches("begin \\d\\d\\d .*")) continue;
            ++count;
        }
        return count;
    }
}

