/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.plugins.emailtest.EmailConfigInfo;
import com.canoo.webtest.util.ConversionUtil;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.log4j.Logger;

public class EmailHelper {
    private static final Logger LOG = Logger.getLogger((Class)EmailHelper.class);

    Message[] getMessages(Folder folder) throws MessagingException {
        Message[] msgs = folder.getMessages();
        LOG.debug((Object)("Login to Email server successful, " + msgs.length + " message(s) on server"));
        return msgs;
    }

    Message getMessage(int id, Folder folder) throws MessagingException {
        Message[] msgs = this.getMessages(folder);
        for (int i = 0; i < msgs.length; ++i) {
            if (msgs[i].getMessageNumber() != id) continue;
            return msgs[i];
        }
        return null;
    }

    void markForDelete(Message m) throws MessagingException {
        m.setFlag(Flags.Flag.DELETED, true);
        LOG.debug((Object)("Message " + m.getMessageNumber() + " marked for delete"));
    }

    Folder getInboxFolder(EmailConfigInfo info) throws MessagingException {
        int port = -1;
        String server = info.getServer();
        int colonPosn = server.indexOf(":");
        if (colonPosn != -1) {
            port = EmailHelper.extractPort(server, colonPosn);
            server = server.substring(0, colonPosn);
        }
        EmailHelper.processDelayIfNeeded(info.getDelay());
        Session session = this.getSessionInstance(System.getProperties());
        Store store = this.getStore(session, info.getType());
        store.connect(server, port, info.getUsername(), info.getPassword());
        Folder folder = store.getDefaultFolder();
        if (folder == null) {
            throw new MessagingException("No default folder");
        }
        if ((folder = folder.getFolder("INBOX")) == null) {
            throw new MessagingException("No INBOX");
        }
        folder.open(2);
        return folder;
    }

    private static int extractPort(String server, int colonPosn) throws MessagingException {
        String portStr = server.substring(colonPosn + 1);
        try {
            return Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            throw new MessagingException("Port must be numeric, illegal value: " + portStr);
        }
    }

    private static void processDelayIfNeeded(String delayStr) throws MessagingException {
        if (delayStr != null) {
            try {
                int delay = ConversionUtil.convertToInt(delayStr, 0);
                Thread.sleep(delay * 1000);
            }
            catch (NumberFormatException nfe) {
                throw new MessagingException("Delay must be numeric, illegal value: " + delayStr);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected Store getStore(Session session, String type) throws NoSuchProviderException {
        return session.getStore(type);
    }

    protected Session getSessionInstance(Properties properties) {
        return Session.getInstance((Properties)properties);
    }

    void logout(Folder folder, boolean deleteOnServer) {
        try {
            if (folder != null) {
                LOG.debug((Object)"closing INBOX...");
                folder.close(deleteOnServer);
            }
        }
        catch (MessagingException e) {
            LOG.warn((Object)"Failed to close INBOX folder.", (Throwable)e);
        }
    }
}

