/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.spider;

import com.canoo.webtest.extension.spider.ExecuteStepValidator;
import com.canoo.webtest.extension.spider.IReporter;
import com.canoo.webtest.extension.spider.IValidator;
import com.canoo.webtest.extension.spider.IVisitorStrategy;
import com.canoo.webtest.extension.spider.PatternVisitorStrategy;
import com.canoo.webtest.extension.spider.SeparatedValueReporter;
import com.canoo.webtest.extension.spider.Spider;
import com.canoo.webtest.steps.AbstractStepContainer;
import com.canoo.webtest.util.ConversionUtil;
import org.apache.log4j.Logger;

public class ReportSiteStep
extends AbstractStepContainer {
    private static final Logger LOG = Logger.getLogger((Class)ReportSiteStep.class);
    public static final String[] HEADERS = new String[]{"Depth", "Verify"};
    private String fFile;
    private String fDepth;
    private int fDepthCount;

    public void setFile(String filename) {
        this.fFile = filename;
    }

    public String getFile() {
        return this.fFile;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.optionalIntegerParamCheck(this.getDepth(), "depth", true);
        this.fDepthCount = ConversionUtil.convertToInt(this.getDepth(), 0);
    }

    public void setDepth(String depth) {
        this.fDepth = depth;
    }

    public String getDepth() {
        return this.fDepth;
    }

    public void doExecute() throws CloneNotSupportedException {
        LOG.debug((Object)"Creating spider");
        Spider spider = new Spider();
        spider.setDepth(this.fDepthCount);
        spider.setFileName(this.getFile());
        spider.setReporter(this.getReporter());
        spider.setVisitorStrategy(this.getVisitorStrategy());
        spider.setValidator(this.getValidator());
        LOG.debug((Object)"Executing spider");
        spider.execute(this.getContext());
    }

    protected IReporter getReporter() {
        return new SeparatedValueReporter(HEADERS);
    }

    protected IVisitorStrategy getVisitorStrategy() {
        return new PatternVisitorStrategy("/.*/");
    }

    protected IValidator getValidator() {
        return new ExecuteStepValidator(this.getContext(), this);
    }
}

