/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.groovy;

import com.canoo.webtest.extension.groovy.GroovyInvoker;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.util.FileUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class GroovyStep
extends Step {
    private static final Logger LOG = Logger.getLogger((Class)GroovyStep.class);
    private File fFile;
    private String fText;
    private boolean fReplaceProperties = false;

    public void doExecute() {
        String script = this.getScript();
        if (this.isReplaceProperties()) {
            script = this.getProject().replaceProperties(script);
        }
        GroovyInvoker invoker = new GroovyInvoker();
        invoker.doExecute(this, script);
    }

    public boolean isReplaceProperties() {
        return this.fReplaceProperties;
    }

    public void setReplaceProperties(boolean replaceProperties) {
        this.fReplaceProperties = replaceProperties;
    }

    private String getScript() {
        String script;
        if (this.fFile != null) {
            LOG.debug((Object)("Reading script from file: " + this.fFile));
            script = FileUtil.readFileToString(this.fFile, this);
        } else {
            LOG.debug((Object)"Reading script from nested text");
            script = this.fText;
        }
        return script;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(this.fFile == null && this.fText == null, "Either \"file\" attribute or nested groovy text must be given.");
        this.paramCheck(this.fFile != null && this.fText != null, "Only one of \"file\" attribute or nested groovy text may be given.");
    }

    public void setFile(File fileName) {
        this.fFile = fileName;
    }

    public File getFile() {
        return this.fFile;
    }

    public void addText(String text) {
        this.fText = text;
    }
}

