/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.dialogs;

import com.canoo.webtest.ant.WebtestTask;
import com.canoo.webtest.boundary.AntBoundary;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.extension.dialogs.AbstractDialogStep;
import com.canoo.webtest.extension.dialogs.DialogHelper;
import com.canoo.webtest.steps.AbstractStepContainer;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import java.util.Iterator;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Task;

public class ExpectDialogs
extends AbstractStepContainer {
    private static final Logger LOG = Logger.getLogger((Class)ExpectDialogs.class);

    public void doExecute() {
        Context context = this.getContext();
        DialogHelper.clearExpectedDialogs(context);
        WebClient wc = context.getWebClient();
        Iterator iter = this.getSteps().iterator();
        while (iter.hasNext()) {
            Step step = (Step)iter.next();
            DialogHelper.addExpectedDialog(context, (AbstractDialogStep)step);
            this.executeContainedStep(step);
        }
        CheckingDialogHandler handler = new CheckingDialogHandler(context, this);
        wc.setAlertHandler((AlertHandler)handler);
        wc.setConfirmHandler((ConfirmHandler)handler);
        wc.setPromptHandler((PromptHandler)handler);
        LOG.debug((Object)("Dialog expectation saved - now expecting " + DialogHelper.getExpectedDialogsCount(context) + " dialog(s)."));
    }

    public void addTask(Task newTask) {
        Task task = AntBoundary.maybeConfigure(newTask);
        if (!(task instanceof AbstractDialogStep)) {
            throw new StepFailedException("Not a dialog step: " + task);
        }
        super.addTask(task);
    }

    static class CheckingDialogHandler
    implements AlertHandler,
    ConfirmHandler,
    PromptHandler {
        private final Context fContext;
        private final Step fOuter;

        CheckingDialogHandler(Context context, Step outer) {
            this.fContext = context;
            this.fOuter = outer;
        }

        public void handleAlert(Page page, String message) {
            this.checkContext();
            this.checkDialog(message, "AlertDialog");
        }

        private void checkContext() {
            if (WebtestTask.getThreadContext() == null) {
                WebtestTask.setThreadContext(this.fContext);
            }
        }

        public boolean handleConfirm(Page page, String message) {
            this.checkContext();
            AbstractDialogStep thisDialog = this.checkDialog(message, "ConfirmDialog");
            return ConversionUtil.convertToBoolean(thisDialog.getResponse(), true);
        }

        public String handlePrompt(Page page, String message) {
            this.checkContext();
            AbstractDialogStep thisDialog = this.checkDialog(message, "PromptDialog");
            return thisDialog.getResponse();
        }

        private AbstractDialogStep checkDialog(String message, String dialogType) {
            this.checkExpectationsSet(this.fContext);
            AbstractDialogStep thisDialog = DialogHelper.getNextExpectedDialog(this.fContext);
            this.saveResponse(thisDialog, message);
            this.checkResponseType(thisDialog, dialogType);
            thisDialog.verify(message);
            return thisDialog;
        }

        private void checkExpectationsSet(Context context) {
            if (DialogHelper.getExpectedDialogsCount(context) == 0) {
                throw new StepFailedException("Expected dialogs but none found!", this.fOuter);
            }
        }

        private void saveResponse(AbstractDialogStep thisDialog, String message) {
            if (thisDialog.getSaveProperty() != null) {
                this.fOuter.setWebtestProperty(thisDialog.getSaveProperty(), message, thisDialog.getSavePropertyType());
            }
        }

        private void checkResponseType(AbstractDialogStep thisDialog, String dialogType) {
            String name = ClassUtils.getShortClassName(thisDialog.getClass());
            String prefix = name.substring(0, name.length() - 4);
            if (!prefix.equals(dialogType)) {
                throw new StepFailedException("Incorrect dialog type", dialogType, prefix, this.fOuter);
            }
        }
    }
}

