/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.applet.runner.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static final Logger LOG = Logger.getLogger((Class)HttpURLConnection.class);
    private final HeaderGroup fRequestProperties = new HeaderGroup();
    private static HttpClient sHttpClient;
    private HttpMethod fHttpRequestMethod = new GetMethod(this.url.toExternalForm());
    private static Cookie[] sCookies;
    private ByteArrayOutputStream fOutputStream;

    public static void setCookies(Cookie[] cookies) {
        sCookies = cookies;
    }

    public HttpURLConnection(URL url) {
        this(url, sHttpClient);
    }

    HttpURLConnection(URL url, HttpClient httpClient) {
        super(url);
        sHttpClient = httpClient;
        if (sCookies != null && sCookies.length > 0) {
            LOG.debug((Object)"Adding cookies to state");
            sHttpClient.getState().addCookies(sCookies);
        }
        LOG.debug((Object)("new HttpURLConnection(" + url.toExternalForm() + ")."));
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() {
        throw new NoSuchMethodError("Not yet implemented");
    }

    public boolean usingProxy() {
        return false;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        LOG.info((Object)("connect(" + this.url.toExternalForm() + ")"));
        Header[] headers = this.fRequestProperties.getAllHeaders();
        for (int i = 0; i < headers.length; ++i) {
            this.fHttpRequestMethod.setRequestHeader(headers[i]);
        }
        if (this.fOutputStream != null) {
            ((EntityEnclosingMethod)this.fHttpRequestMethod).setRequestEntity((RequestEntity)new ByteArrayRequestEntity(this.fOutputStream.toByteArray()));
        }
        this.responseCode = sHttpClient.executeMethod(this.fHttpRequestMethod);
        if (this.responseCode != 200) {
            LOG.error((Object)(this.fHttpRequestMethod.getName() + " " + this.url.toExternalForm() + " failed: " + this.fHttpRequestMethod.getStatusLine()));
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        LOG.info((Object)("getInputStream(" + this.url.toExternalForm() + ")"));
        if (!this.getDoInput()) {
            LOG.error((Object)"Input not allowed");
            throw new ProtocolException("Input not allowed on this connection");
        }
        this.connect();
        return this.fHttpRequestMethod.getResponseBodyAsStream();
    }

    public OutputStream getOutputStream() throws IOException {
        LOG.info((Object)("getOutputStream(" + this.url.toExternalForm() + ")"));
        if (!this.getDoOutput()) {
            LOG.error((Object)"Output not allowed");
            throw new ProtocolException("Output not allowed on this connection");
        }
        if (this.fHttpRequestMethod instanceof GetMethod) {
            this.setRequestMethod("POST");
        }
        if (!(this.fHttpRequestMethod instanceof EntityEnclosingMethod)) {
            throw new UnknownServiceException(this.fHttpRequestMethod.getName() + " doesn't support output.");
        }
        this.fOutputStream = new ByteArrayOutputStream();
        return this.fOutputStream;
    }

    public String getHeaderFieldKey(int n) {
        Header[] headers = this.fHttpRequestMethod.getResponseHeaders();
        if (n >= headers.length) {
            LOG.info((Object)("getHeaderFieldKey(" + n + ") -> null"));
            return null;
        }
        String name = headers[n].getName();
        LOG.info((Object)("getHeaderFieldKey(" + n + ") -> " + name));
        return name;
    }

    public String getHeaderField(int n) {
        Header[] headers = this.fHttpRequestMethod.getResponseHeaders();
        if (n >= headers.length) {
            LOG.info((Object)("getHeaderField(" + n + ") -> null"));
            return null;
        }
        String value = headers[n].getValue();
        LOG.info((Object)("getHeaderField(" + n + ") -> " + value));
        return value;
    }

    public String getHeaderField(String name) {
        Header responseHeader = this.fHttpRequestMethod.getResponseHeader(name);
        if (responseHeader == null) {
            LOG.info((Object)("getHeaderField(" + name + ") -> null"));
            return null;
        }
        String value = responseHeader.getValue();
        if (value == null) {
            LOG.info((Object)("getHeaderField(" + name + ") -> null"));
            return null;
        }
        String trimmedValue = value.substring(value.lastIndexOf(44) + 1).trim();
        LOG.info((Object)("getHeaderField(" + name + ") -> " + trimmedValue));
        return trimmedValue;
    }

    public Map getHeaderFields() {
        LOG.info((Object)"getHeaderFields()");
        HashMap hf = new HashMap();
        Header[] headers = this.fHttpRequestMethod.getResponseHeaders();
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            ArrayList<String> values = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(header.getValue(), ",");
            while (st.hasMoreTokens()) {
                values.add(st.nextToken().trim());
            }
            hf.put(header.getName(), Collections.unmodifiableList(values));
        }
        return Collections.unmodifiableMap(hf);
    }

    public void setRequestProperty(String key, String value) {
        LOG.info((Object)("setRequestProperty(" + key + ", " + value + ")"));
        super.setRequestProperty(key, value);
        if (this.fRequestProperties.containsHeader(key)) {
            Header[] headers = this.fRequestProperties.getHeaders(key);
            for (int i = 0; i < headers.length; ++i) {
                this.fRequestProperties.removeHeader(headers[i]);
            }
        }
        this.fRequestProperties.addHeader(new Header(key, value));
    }

    public void addRequestProperty(String key, String value) {
        LOG.info((Object)("addRequestProperty(" + key + ", " + value + ")"));
        super.addRequestProperty(key, value);
        this.fRequestProperties.addHeader(new Header(key, value));
    }

    public String getRequestProperty(String key) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            return null;
        }
        Header header = this.fRequestProperties.getCondensedHeader(key);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public Map getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        Header[] headers = this.fRequestProperties.getAllHeaders();
        if (headers.length == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, ArrayList<String>> hf = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            ArrayList<String> list = (ArrayList<String>)hf.get(header.getName());
            if (list == null) {
                list = new ArrayList<String>();
                hf.put(header.getName(), list);
            }
            list.add(header.getValue());
        }
        return Collections.unmodifiableMap(hf);
    }

    public void setRequestMethod(String method) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Can't reset method: already connected");
        }
        if (this.fOutputStream != null) {
            throw new ProtocolException("Can't reset method: output stream already allocated");
        }
        LOG.info((Object)("setRequestMethod(" + method + ")"));
        if ("GET".equals(method)) {
            this.setHttpRequestMethod((HttpMethod)new GetMethod(this.url.toExternalForm()));
        } else if ("POST".equals(method)) {
            this.setHttpRequestMethod((HttpMethod)new PostMethod(this.url.toExternalForm()));
        } else {
            throw new ProtocolException("Not implemented/Invalid HTTP method: " + method);
        }
    }

    public String getRequestMethod() {
        return this.fHttpRequestMethod.getName();
    }

    HttpMethod getHttpRequestMethod() {
        return this.fHttpRequestMethod;
    }

    void setHttpRequestMethod(HttpMethod method) {
        this.fHttpRequestMethod = method;
    }

    public int getResponseCode() throws IOException {
        return this.fHttpRequestMethod.getStatusCode();
    }

    public String getResponseMessage() throws IOException {
        return this.fHttpRequestMethod.getStatusText();
    }

    static {
        System.setProperty("apache.commons.httpclient.cookiespec", "COMPATIBILITY");
        sHttpClient = new HttpClient();
    }
}

