/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.applet.runner;

import com.canoo.webtest.boundary.AppletRunnerBoundary;
import com.canoo.webtest.boundary.StreamBoundary;
import com.canoo.webtest.extension.applet.AppletPluginArguments;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.log4j.Logger;

public class AppletRunnerHelper {
    private static final Logger LOG = Logger.getLogger((Class)AppletRunnerHelper.class);
    private final int fClassNotFoundErrorCode;
    private final int fIoErrorCode;
    private final AppletRunnerBoundary fBoundary;

    public AppletRunnerHelper(int classNotFoundErrorCode, int ioErrorCode, AppletRunnerBoundary boundary) {
        this.fClassNotFoundErrorCode = classNotFoundErrorCode;
        this.fIoErrorCode = ioErrorCode;
        this.fBoundary = boundary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public AppletPluginArguments readPluginArguments(String file) {
        AppletPluginArguments appletPluginArguments;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            ois = this.createObjectInputStream(fis);
            appletPluginArguments = (AppletPluginArguments)this.readObject(ois);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Can't deserialize the arguments.", (Throwable)e);
            this.fBoundary.processClassNotFound(this.fClassNotFoundErrorCode);
            StreamBoundary.closeInputStream(ois);
            StreamBoundary.closeInputStream(fis);
        }
        catch (IOException e2) {
            LOG.error((Object)"Can't read the arguments file.", (Throwable)e2);
            this.fBoundary.processIoException(this.fIoErrorCode);
            {
                catch (Throwable throwable) {
                    StreamBoundary.closeInputStream(ois);
                    StreamBoundary.closeInputStream(fis);
                    throw throwable;
                }
            }
            StreamBoundary.closeInputStream(ois);
            StreamBoundary.closeInputStream(fis);
        }
        StreamBoundary.closeInputStream(ois);
        StreamBoundary.closeInputStream(fis);
        return appletPluginArguments;
        return null;
    }

    protected ObjectInputStream createObjectInputStream(FileInputStream fis) throws IOException {
        return new ObjectInputStream(fis);
    }

    protected Object readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return ois.readObject();
    }
}

