/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.Step;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class VerifyImages
extends Step {
    private static final Logger LOG = Logger.getLogger((Class)VerifyImages.class);

    public void doExecute() {
        this.nullResponseCheck();
        Context context = this.getContext();
        WebClient conversation = context.getWebClient();
        HtmlPage currentResponse = context.getCurrentHtmlResponse(this);
        context.suspendWindowListener();
        Collection colFailedImagesSrc = VerifyImages.checkImages(conversation, currentResponse);
        context.restoreWindowListener();
        if (!colFailedImagesSrc.isEmpty()) {
            StepFailedException sfe = new StepFailedException(colFailedImagesSrc.size() + " missing image(s) in page " + currentResponse.getWebResponse().getUrl());
            StringBuffer sb = new StringBuffer();
            Iterator iter = colFailedImagesSrc.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next()).append("\r\n ");
            }
            sfe.addDetail("missing images", sb.toString());
            throw sfe;
        }
    }

    private static Collection checkImages(WebClient webClient, HtmlPage htmlPage) {
        Set uris = VerifyImages.collectImageUris(htmlPage);
        boolean bPreviousThrowExceptionOnFailingStatusCode = webClient.isThrowExceptionOnFailingStatusCode();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        Iterator iter = uris.iterator();
        while (iter.hasNext()) {
            String src = (String)iter.next();
            VerifyImages.tryGetImage(htmlPage, src, webClient, iter);
        }
        webClient.setThrowExceptionOnFailingStatusCode(bPreviousThrowExceptionOnFailingStatusCode);
        if (!uris.isEmpty()) {
            LOG.info((Object)("Number of failing images found: " + uris.size()));
        }
        return uris;
    }

    private static void tryGetImage(HtmlPage htmlPage, String src, WebClient webClient, Iterator iter) {
        try {
            URL url = htmlPage.getFullyQualifiedUrl(src);
            Page resp = webClient.getPage(url);
            if (!(resp instanceof UnexpectedPage)) {
                LOG.info((Object)("Failed image with src=\"" + src + "\": content type is " + resp.getWebResponse().getContentType()));
            } else {
                LOG.debug((Object)("Image with src=\"" + src + "\" is ok"));
                iter.remove();
            }
        }
        catch (Exception e) {
            LOG.info((Object)("Failed image with src=\"" + src + "\""));
        }
    }

    private static Set collectImageUris(HtmlPage htmlPage) {
        TreeSet<String> uris = new TreeSet<String>();
        Iterator iter = htmlPage.getDocumentHtmlElement().getHtmlElementsByTagName("img").iterator();
        while (iter.hasNext()) {
            HtmlImage img = (HtmlImage)iter.next();
            uris.add(img.getSrcAttribute());
        }
        List inputImages = htmlPage.getDocumentHtmlElement().getHtmlElementsByAttribute("input", "type", "image");
        Iterator iter2 = inputImages.iterator();
        while (iter2.hasNext()) {
            HtmlInput img = (HtmlInput)iter2.next();
            uris.add(img.getSrcAttribute());
        }
        return uris;
    }
}

