/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.boundary.HtmlUnitBoundary;
import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.steps.store.BaseStoreStep;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import org.apache.log4j.Logger;

public class StoreElementAttribute
extends BaseStoreStep {
    private static final Logger LOG = Logger.getLogger((Class)StoreElementAttribute.class);
    private String fHtmlId;
    private String fXPath;
    private String fAttributeName;

    public void doExecute() throws Exception {
        this.nullResponseCheck();
        HtmlElement element = StoreElementAttribute.findElement(this.getContext().getCurrentResponse(), this.getHtmlId(), this.getXpath(), LOG, this);
        String retval = element.getAttributeValue(this.getAttributeName());
        if (retval == HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            retval = "undefined";
        } else if (retval == HtmlElement.ATTRIBUTE_VALUE_EMPTY || retval.length() == 0) {
            retval = "empty";
        }
        this.storeProperty(retval);
    }

    public static HtmlElement findElement(Page currentResp, String id, String xpathStr, Logger log, Step step) throws StepFailedException {
        if (id != null) {
            return StoreElementAttribute.findElementById(currentResp, id, log, step);
        }
        return StoreElementAttribute.findElementByXpath(currentResp, xpathStr, log, step);
    }

    static HtmlElement findElementById(Page currentResp, String id, Logger log, Step step) throws StepFailedException {
        log.debug((Object)("Looking for element with id \"" + id + "\""));
        try {
            if (!(currentResp instanceof HtmlPage)) {
                throw new StepExecutionException("Current response is not an HTML page but of type " + currentResp.getWebResponse().getContentType(), step);
            }
            HtmlPage lastHtmlResp = (HtmlPage)currentResp;
            HtmlElement element = lastHtmlResp.getHtmlElementById(id);
            log.debug((Object)("found element with id \"" + id + "\": " + element));
            return element;
        }
        catch (ElementNotFoundException e) {
            throw new StepFailedException("No element found with id \"" + id + "\".", step);
        }
    }

    static HtmlElement findElementByXpath(Page currentResp, String xpathStr, Logger log, Step step) throws StepFailedException {
        log.debug((Object)("Looking for element with xpath \"" + xpathStr + "\""));
        Object node = HtmlUnitBoundary.trySelectSingleNodeByXPath(xpathStr, currentResp, step);
        if (node == null) {
            throw new StepFailedException("No element found with xpath \"" + xpathStr + "\".", step);
        }
        try {
            return (HtmlElement)node;
        }
        catch (ClassCastException cce) {
            throw new StepFailedException("The xpath doesn't select an Element: '" + node.getClass() + "'");
        }
    }

    public void setHtmlId(String str) {
        this.fHtmlId = str;
    }

    public String getHtmlId() {
        return this.fHtmlId;
    }

    public void setXpath(String path) {
        this.fXPath = path;
    }

    public String getXpath() {
        return this.fXPath;
    }

    public void setAttributeName(String name) {
        this.fAttributeName = name;
    }

    public String getAttributeName() {
        return this.fAttributeName;
    }

    public void setPropertyName(String name) {
        LOG.warn((Object)"'propertyName' is deprecated. Use 'property' instead");
        this.setProperty(name);
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(this.getHtmlId() == null && this.getXpath() == null, "\"htmlId\" or \"xPath\" must be set!");
        this.paramCheck(this.getHtmlId() != null && this.getXpath() != null, "Only one from \"htmlId\" and \"xPath\" can be set!");
        this.nullParamCheck(this.getProperty(), "property");
        this.nullParamCheck(this.getAttributeName(), "attributeName");
    }
}

