/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.steps.AbstractFilter;
import com.gargoylesoftware.htmlunit.WebResponse;

public class LineSeparatorFilter
extends AbstractFilter {
    private static final String LF = "\n";

    public void doExecute() throws Exception {
        WebResponse webResponse = this.getContext().getCurrentResponse().getWebResponse();
        String content = webResponse.getContentAsString();
        String origType = webResponse.getContentType();
        String sep = System.getProperty("line.separator");
        int sepSize = sep.length();
        StringBuffer buf = new StringBuffer();
        int last = 0;
        int pos = content.indexOf(sep, last);
        while (pos != -1) {
            buf.append(content.substring(last, pos));
            buf.append(LF);
            last = pos + sepSize;
            pos = content.indexOf(sep, last);
        }
        if (last != content.length()) {
            buf.append(content.substring(last));
        }
        this.defineAsCurrentResponse(buf.toString(), origType);
    }
}

