/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.util.Checker;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.apache.log4j.Logger;

public class WebClientContext {
    private static final Logger LOG = Logger.getLogger((Class)WebClientContext.class);
    private WebClient fWebClient;
    private String fSavedUserName;
    private String fSavedPassword;
    private StoredResponse fPreviousResponse = NO_STORED_RESPONSE;
    private StoredResponse fCurrentResponse = NO_STORED_RESPONSE;
    private static final StoredResponse NO_STORED_RESPONSE = new StoredResponse(null);
    private final WebWindowListener fWindowListener = new CurrentWindowTracker();
    private final Stack fWindows = new Stack();
    private HtmlForm fCurrentForm;

    public WebClient getWebClient() {
        return this.fWebClient;
    }

    public String getSavedUserName() {
        return this.fSavedUserName;
    }

    public String getSavedPassword() {
        return this.fSavedPassword;
    }

    public StoredResponses getResponses() {
        return new StoredResponses(this);
    }

    public void restoreResponses(StoredResponses savedResponses) {
        this.fPreviousResponse = savedResponses.fPreviousResponse;
        this.fCurrentResponse = savedResponses.fCurrentResponse;
        LOG.info((Object)"Responses restored");
    }

    public Page getCurrentResponse() {
        if (this.fCurrentResponse.getPage() != null && !this.fWebClient.getWebWindows().contains(this.fCurrentResponse.getPage().getEnclosingWindow())) {
            LOG.info((Object)"The window containing current response has been closed, the content of the last opened window will become the current response");
            WebWindow window = (WebWindow)this.fWindows.peek();
            this.saveResponseAsCurrent(window.getEnclosedPage());
        }
        return this.fCurrentResponse.getPage();
    }

    public String getCurrentResponseFile() {
        return this.fCurrentResponse.getFile();
    }

    public void setCurrentResponseFile(String name) {
        this.fCurrentResponse.setFile(name);
    }

    public HtmlPage getCurrentHtmlResponse(Step step) {
        if (!(this.getCurrentResponse() instanceof HtmlPage)) {
            throw new StepExecutionException("Current response is not an HTML page but of type " + this.getCurrentResponse().getWebResponse().getContentType(), step);
        }
        return (HtmlPage)this.getCurrentResponse();
    }

    public void restorePreviousResponse() {
        WebWindow window = this.fPreviousResponse.getPage().getEnclosingWindow();
        if (!this.fWebClient.getWebWindows().contains(window)) {
            this.fWebClient.registerWebWindow(window);
        }
        this.saveResponseAsCurrent(this.fPreviousResponse);
    }

    public void saveResponseAsCurrent(Page page) {
        this.saveResponseAsCurrent(new StoredResponse(page));
    }

    protected void saveResponseAsCurrent(StoredResponse current) {
        Checker.assertFalse(current == null || current.getPage() == null, "Illegal new current response");
        this.setCurrentForm(null);
        this.fPreviousResponse = this.fCurrentResponse;
        this.fCurrentResponse = current;
        LOG.info((Object)("Current response now: " + current.getPage().getWebResponse().getUrl()));
        LOG.debug((Object)("Previous response: " + (this.fPreviousResponse.getPage() != null ? this.fPreviousResponse.getPage().getWebResponse().getUrl() : null)));
    }

    public void setWebClient(WebClient webClient) {
        this.fWebClient = webClient;
        this.restoreWindowListener();
        this.fWindows.push(webClient.getCurrentWindow());
    }

    public void suspendWindowListener() {
        this.fWebClient.removeWebWindowListener(this.fWindowListener);
    }

    public void restoreWindowListener() {
        this.fWebClient.addWebWindowListener(this.fWindowListener);
    }

    public void setSavedUserName(String userName) {
        this.fSavedUserName = userName;
    }

    public void setSavedPassword(String password) {
        this.fSavedPassword = password;
    }

    public HtmlForm getCurrentForm() {
        return this.fCurrentForm;
    }

    public void setCurrentForm(HtmlForm form) {
        this.fCurrentForm = form;
        if (form != null) {
            LOG.info((Object)("Current form set to (action=" + form.getActionAttribute() + ")"));
        } else {
            LOG.info((Object)"Current form set to none");
        }
    }

    public void destroy() {
        WebWindow window;
        this.suspendWindowListener();
        ArrayList<WebWindow> topWindows = new ArrayList<WebWindow>();
        Iterator iter = this.fWebClient.getWebWindows().iterator();
        while (iter.hasNext()) {
            window = (WebWindow)iter.next();
            if (!(window instanceof TopLevelWindow)) continue;
            topWindows.add(window);
        }
        iter = topWindows.iterator();
        while (iter.hasNext()) {
            window = (TopLevelWindow)iter.next();
            window.close();
        }
        this.fWebClient = null;
        this.fPreviousResponse = null;
        this.fCurrentResponse = null;
        this.fWindows.empty();
        this.fCurrentForm = null;
    }

    class CurrentWindowTracker
    implements WebWindowListener {
        CurrentWindowTracker() {
        }

        public void webWindowClosed(WebWindowEvent event) {
            WebClientContext.this.fWindows.remove(event.getWebWindow());
            LOG.debug((Object)("Window closed (contains: " + event.getWebWindow().getEnclosedPage().getWebResponse().getUrl() + ")"));
        }

        public void webWindowContentChanged(WebWindowEvent event) {
            boolean takeItAsNew;
            WebWindow window = event.getWebWindow();
            WebResponse webResp = event.getNewPage().getWebResponse();
            LOG.info((Object)("Content of window changed to " + webResp.getUrl() + " (" + webResp.getContentType() + ")"));
            if (window instanceof TopLevelWindow && event.getOldPage() == null) {
                takeItAsNew = true;
                LOG.info((Object)"Content loaded in newly opened window, its content will become current response");
            } else if (WebClientContext.this.fCurrentResponse.getPage() != null && WebClientContext.this.fCurrentResponse.getPage().getEnclosingWindow() == window) {
                takeItAsNew = true;
                LOG.info((Object)"Content of current window changed, it will become current response");
            } else if (WebClientContext.this.getWebClient().getJavaScriptEngine() == null || !WebClientContext.this.getWebClient().getJavaScriptEngine().isScriptRunning()) {
                if (window instanceof FrameWindow && !"complete".equals(((FrameWindow)window).getEnclosingPage().getDocumentHtmlElement().getReadyState())) {
                    LOG.info((Object)"Content of frame window has changed without javascript while enclosing page is loading, it will NOT become current response");
                    LOG.debug((Object)("Enclosing page's state: " + ((FrameWindow)window).getEnclosingPage().getDocumentHtmlElement().getReadyState()));
                    LOG.debug((Object)("Enclosing page's url: " + ((FrameWindow)window).getEnclosingPage().getWebResponse().getUrl()));
                    takeItAsNew = false;
                } else {
                    LOG.info((Object)"Content of window changed without javascript, it will become current response");
                    takeItAsNew = true;
                }
            } else {
                LOG.info((Object)"Content of window changed with javascript, it will NOT become current response");
                takeItAsNew = false;
            }
            if (takeItAsNew) {
                WebClientContext.this.saveResponseAsCurrent(window.getEnclosedPage());
            }
        }

        public void webWindowOpened(WebWindowEvent event) {
            WebClientContext.this.fWindows.push(event.getWebWindow());
        }
    }

    static class StoredResponse {
        private final Page fPage;
        private String fFile;

        StoredResponse(Page page) {
            this.fPage = page;
        }

        public Page getPage() {
            return this.fPage;
        }

        public String getFile() {
            return this.fFile;
        }

        public void setFile(String file) {
            this.fFile = file;
        }
    }

    public static final class StoredResponses {
        private final StoredResponse fPreviousResponse;
        private final StoredResponse fCurrentResponse;

        private StoredResponses(WebClientContext context) {
            this.fPreviousResponse = context.fPreviousResponse;
            this.fCurrentResponse = context.fCurrentResponse;
        }
    }
}

