/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.boundary;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.xpath.XPathHelper;
import com.canoo.webtest.steps.Step;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jaxen.XPath;

public final class HtmlUnitBoundary {
    private static final Logger LOG = Logger.getLogger((Class)HtmlUnitBoundary.class);

    private HtmlUnitBoundary() {
    }

    public static Page tryGetPage(URL url, WebClient webClient) {
        return HtmlUnitBoundary.tryGetPage(url, webClient, true);
    }

    public static Page tryGetPageNoFail(URL url, WebClient webClient) {
        return HtmlUnitBoundary.tryGetPage(url, webClient, false);
    }

    private static Page tryGetPage(URL url, WebClient webClient, boolean shouldFail) {
        try {
            LOG.debug((Object)("Visiting: " + url + " (fail=" + shouldFail + ")"));
            return webClient.getPage(url);
        }
        catch (FailingHttpStatusCodeException e) {
            LOG.debug((Object)("Testing " + url + " failed: status code " + e.getStatusCode() + "(" + e.getStatusMessage() + ")"));
            return HtmlUnitBoundary.returnNullOrFail((Exception)((Object)e), shouldFail);
        }
        catch (IOException e) {
            LOG.debug((Object)("Testing " + url + " failed: IOException " + e.getMessage()));
            return HtmlUnitBoundary.returnNullOrFail(e, shouldFail);
        }
    }

    private static Page returnNullOrFail(Exception e, boolean shouldFail) {
        if (shouldFail) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static Object trySelectSingleNodeByXPath(String xpathStr, Page currentResp, Step step) {
        try {
            XPathHelper xpathHelper = step.getContext().getXPathHelper();
            XPath xpath = xpathHelper.getXPath(currentResp, xpathStr);
            return xpath.selectSingleNode(xpathHelper.getDocument(currentResp));
        }
        catch (JaxenException e) {
            throw new StepExecutionException("Error processing xpath \"" + xpathStr + "\".", step, e);
        }
    }
}

