/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.ant.task;

import com.canoo.ant.filter.ITableFilter;
import com.canoo.ant.table.APropertyTable;
import com.canoo.ant.table.ExcelPropertyTable;
import com.canoo.ant.table.IPropertyTable;
import com.canoo.ant.table.TableFactory;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class PropertyTableTask
extends Task
implements TaskContainer {
    private static final Logger LOG = Logger.getLogger((Class)PropertyTableTask.class);
    private List fTasks = new LinkedList();
    private Properties fProps = new Properties();
    private String fName;
    private String fValue;
    private File fTableContainer;
    private boolean replaceProperties;

    public void setReplaceProperties(boolean replaceProperties) {
        this.replaceProperties = replaceProperties;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setTableclass(String tableClass) {
        this.fProps.setProperty("tableClass", tableClass);
    }

    public void setFilterclass(String filterClass) {
        this.fProps.setProperty("filterClass", filterClass);
    }

    public void setTable(String table) {
        this.fProps.setProperty("foreignTable", table);
    }

    public void setTableContainer(File container) throws IOException {
        this.fTableContainer = container;
    }

    public void setContainer(File container) throws IOException {
        this.setTableContainer(container);
    }

    public void addTask(Task task) {
        this.fTasks.add(task);
    }

    public void execute() throws BuildException {
        ITableFilter filter;
        IPropertyTable table;
        try {
            table = TableFactory.createTable(this.fProps, ExcelPropertyTable.class.getName());
            filter = TableFactory.createFilter(this.fProps);
        }
        catch (Exception e) {
            throw new BuildException("cannot create container", (Throwable)e, this.getLocation());
        }
        TableFactory.initOrDefault(table, filter, this.fProps, this.fTableContainer, this.fName);
        List propertiesList = table.getPropertiesList(this.fValue, null);
        LOG.debug((Object)("propertiesList.size() = " + propertiesList.size()));
        if (propertiesList.isEmpty()) {
            LOG.warn((Object)("no match found in table " + table.getClass().getName() + " with filter " + table.getFilter().getClass().getName() + " and settings " + this.fProps.toString() + " raw data:" + ((APropertyTable)table).getRawTable()));
        }
        Iterator eachPropSet = propertiesList.iterator();
        while (eachPropSet.hasNext()) {
            Properties propSet = (Properties)eachPropSet.next();
            Iterator<Object> eachKey = propSet.keySet().iterator();
            while (eachKey.hasNext()) {
                String key = (String)eachKey.next();
                String value = propSet.getProperty(key);
                if (this.replaceProperties) {
                    value = this.getProject().replaceProperties(value);
                }
                LOG.debug((Object)("setting key/value " + key + "/" + value));
                this.getProject().setInheritedProperty(key, value);
            }
            Iterator eachTask = this.fTasks.iterator();
            while (eachTask.hasNext()) {
                Task task = (Task)eachTask.next();
                task.perform();
            }
        }
    }
}

