/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.ant.table;

import com.canoo.ant.table.APropertyTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelPropertyTable
extends APropertyTable {
    private static final Logger LOG = Logger.getLogger((Class)ExcelPropertyTable.class);

    protected boolean hasJoinTable() {
        HSSFSheet sheet;
        try {
            sheet = this.getWorkbook().getSheet("JOIN");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read container: >" + this.getContainer() + "<", e);
        }
        return sheet != null;
    }

    private HSSFWorkbook getWorkbook() throws IOException {
        File file = this.getContainer();
        if (!file.exists()) {
            throw new FileNotFoundException("File not found >" + file.getAbsolutePath() + "< " + this.getContainer());
        }
        if (!file.isFile() || !file.canRead()) {
            throw new IllegalArgumentException("No a regular readable file: >" + file.getAbsolutePath() + "<");
        }
        POIFSFileSystem excelFile = new POIFSFileSystem((InputStream)new FileInputStream(file));
        return new HSSFWorkbook(excelFile);
    }

    protected List read(String sheetName) throws IOException {
        HSSFWorkbook workbook = this.getWorkbook();
        HSSFSheet sheet = sheetName == null ? workbook.getSheetAt(0) : workbook.getSheet(sheetName);
        if (null == sheet) {
            String msg = "No sheet \"" + sheetName + "\" found in file " + this.getContainer() + ". Available sheets: ";
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                if (i != 0) {
                    msg = msg + ", ";
                }
                msg = msg + workbook.getSheetName(i);
            }
            throw new IllegalArgumentException(msg);
        }
        int lastRowNum = sheet.getLastRowNum();
        ArrayList<String> header = new ArrayList<String>();
        HSSFRow headerRow = sheet.getRow(0);
        for (short i = 0; i < headerRow.getLastCellNum(); i = (short)(i + 1)) {
            HSSFCell cell = headerRow.getCell(i);
            if (cell != null) {
                header.add(this.stringValueOf(cell));
                continue;
            }
            header.add(null);
        }
        LinkedList<Properties> result = new LinkedList<Properties>();
        for (int rowNo = 1; rowNo <= lastRowNum; ++rowNo) {
            HSSFRow row = sheet.getRow(rowNo);
            if (row == null) continue;
            Properties props = new Properties();
            for (short i = 0; i < header.size(); i = (short)(i + 1)) {
                String headerName = (String)header.get(i);
                if (headerName == null) continue;
                HSSFCell cell = row.getCell(i);
                String value = this.stringValueOf(cell);
                this.putValue(value, headerName, props);
            }
            result.add(props);
        }
        return result;
    }

    protected void putValue(String value, Object key, Properties props) {
        if (!"".equals(value)) {
            props.put(key, value);
        }
    }

    private String stringValueOf(HSSFCell cell) {
        if (null == cell) {
            return "";
        }
        switch (cell.getCellType()) {
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 0: {
                return "" + cell.getNumericCellValue();
            }
            case 3: {
                return "";
            }
            case 4: {
                return "" + cell.getBooleanCellValue();
            }
        }
        LOG.warn((Object)("Cell Type not supported: " + cell.getCellType()));
        return "";
    }
}

