/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.ant.table;

import com.canoo.ant.table.APropertyTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DirectoryPropertyTable
extends APropertyTable {
    private static final Logger LOG = Logger.getLogger((Class)DirectoryPropertyTable.class);
    private static final String PROP_FILE_SUFFIX = ".properties";

    protected List read(String subdir) throws IOException {
        LinkedList<Properties> result = new LinkedList<Properties>();
        File containerDir = new File(this.getContainer() + File.separator + subdir);
        if (!containerDir.isDirectory()) {
            if (subdir.equals("JOIN")) {
                LOG.debug((Object)("no meta info available in " + this.getContainer()));
            } else {
                LOG.error((Object)(containerDir.getCanonicalPath() + " is not a directory"));
            }
            return result;
        }
        File[] files = containerDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(DirectoryPropertyTable.PROP_FILE_SUFFIX);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            Properties props = new Properties();
            props.load(new FileInputStream(file));
            props.setProperty(subdir + ".file.name", this.simpleName(file));
            LOG.debug((Object)("loaded " + file.getCanonicalPath() + " with values " + props.toString()));
            result.add(props);
        }
        return result;
    }

    private String simpleName(File file) {
        String name = file.getName();
        return name.substring(0, name.length() - PROP_FILE_SUFFIX.length());
    }
}

