/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.regexp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.RegExpImpl;

public class HtmlUnitRegExpProxy
extends RegExpImpl {
    private final RegExpProxy wrapped_;

    public HtmlUnitRegExpProxy(RegExpProxy wrapped) {
        this.wrapped_ = wrapped;
    }

    public Object action(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        if (2 == actionType && args.length == 2 && args[1] instanceof String) {
            String thisString = Context.toString((Object)thisObj);
            String replacement = ((String)args[1]).replaceAll("\\\\", "\\\\\\\\");
            Object arg0 = args[0];
            if (arg0 instanceof String) {
                return StringUtils.replaceOnce((String)thisString, (String)((String)arg0), (String)replacement);
            }
            if (arg0 instanceof NativeRegExp) {
                try {
                    NativeRegExp regexp = (NativeRegExp)arg0;
                    String str = arg0.toString();
                    String regex = this.readNativeRegExpPattern(regexp);
                    String flagsStr = StringUtils.substringAfterLast((String)str, (String)"/");
                    int flags = this.jsFlagsToPatternFlags(flagsStr);
                    Pattern pattern = Pattern.compile(regex, flags);
                    Matcher matcher = pattern.matcher(thisString);
                    if (flagsStr.indexOf(103) != -1) {
                        return matcher.replaceAll(replacement);
                    }
                    return matcher.replaceFirst(replacement);
                }
                catch (PatternSyntaxException e) {
                    this.getLog().warn((Object)e);
                }
            }
        } else if (1 == actionType) {
            int flags;
            String regex;
            if (args.length == 0) {
                return null;
            }
            Object arg0 = args[0];
            String thisString = Context.toString((Object)thisObj);
            if (arg0 instanceof NativeRegExp) {
                regex = this.readNativeRegExpPattern((NativeRegExp)arg0);
                flags = this.readNativeRegExpFlags((NativeRegExp)arg0);
            } else {
                regex = Context.toString((Object)arg0);
                flags = 0;
            }
            Pattern pattern = Pattern.compile(regex, flags);
            Matcher matcher = pattern.matcher(thisString);
            if (!matcher.find()) {
                return null;
            }
            Object[] groups = new Object[matcher.groupCount() + 1];
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                groups[i] = matcher.group(i);
                if (groups[i] != null) continue;
                groups[i] = Context.getUndefinedValue();
            }
            Scriptable response = cx.newArray(scope, groups);
            response.put("index", response, (Object)new Integer(matcher.start(0)));
            response.put("input", response, (Object)thisString);
            return response;
        }
        return this.wrappedAction(cx, scope, thisObj, args, actionType);
    }

    private int readNativeRegExpFlags(NativeRegExp nativeRegExp) {
        String str = nativeRegExp.toString();
        return this.jsFlagsToPatternFlags(str);
    }

    private String readNativeRegExpPattern(NativeRegExp nativeRegExp) {
        String str = nativeRegExp.toString();
        return StringUtils.substringBeforeLast((String)str.substring(1), (String)"/").replaceAll("\\[\\^\\\\\\d\\]", ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object wrappedAction(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        try {
            ScriptRuntime.setRegExpProxy((Context)cx, (RegExpProxy)this.wrapped_);
            Object object = this.wrapped_.action(cx, scope, thisObj, args, actionType);
            return object;
        }
        finally {
            ScriptRuntime.setRegExpProxy((Context)cx, (RegExpProxy)this);
        }
    }

    private int jsFlagsToPatternFlags(String flagsStr) {
        int flags = 0;
        if (flagsStr.indexOf(105) != -1) {
            flags |= 2;
        }
        if (flagsStr.indexOf(109) != -1) {
            flags |= 8;
        }
        return flags;
    }

    public Object compileRegExp(Context cx, String source, String flags) {
        return this.wrapped_.compileRegExp(cx, source, flags);
    }

    public int find_split(Context cx, Scriptable scope, String target, String separator, Scriptable re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        return this.wrapped_.find_split(cx, scope, target, separator, re, ip, matchlen, matched, parensp);
    }

    public boolean isRegExp(Scriptable obj) {
        return this.wrapped_.isRegExp(obj);
    }

    public Scriptable wrapRegExp(Context cx, Scriptable scope, Object compiled) {
        return this.wrapped_.wrapRegExp(cx, scope, compiled);
    }

    protected final Log getLog() {
        return LogFactory.getLog(((Object)((Object)this)).getClass());
    }
}

