/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.XMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.XMLSerializer;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.mozilla.javascript.Context;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSLTProcessor
extends SimpleScriptable {
    private static final long serialVersionUID = -5870183094839129375L;
    private Node style_;
    private Node input_;
    private Object output_;
    private Map parameters_ = new HashMap();

    public void jsConstructor() {
    }

    public void jsxFunction_importStylesheet(Node style) {
        this.style_ = style;
    }

    public XMLDocument jsxFunction_transformToDocument(Node source) {
        XMLDocument doc = new XMLDocument();
        doc.setPrototype(this.getPrototype(((Object)((Object)doc)).getClass()));
        doc.setParentScope(this.getParentScope());
        org.w3c.dom.Node transformedDoc = (org.w3c.dom.Node)this.transform(source);
        XmlPage page = new XmlPage(transformedDoc.getFirstChild(), this.getWindow().getWebWindow());
        doc.setDomNode(page);
        return doc;
    }

    private Object transform(Node source) {
        try {
            StreamSource xmlSource = new StreamSource(new StringReader(((XMLDocument)source).jsxGet_xml()));
            StreamSource xsltSource = new StreamSource(new StringReader(((XMLDocument)this.style_).jsxGet_xml()));
            org.w3c.dom.Document containerDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element containerElement = containerDocument.createElement("container");
            containerDocument.appendChild(containerElement);
            DOMResult result = new DOMResult(containerElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            Iterator keys = this.parameters_.keySet().iterator();
            while (keys.hasNext()) {
                String qualifiedName = (String)keys.next();
                transformer.setParameter(qualifiedName, this.parameters_.get(qualifiedName));
            }
            transformer.transform(xmlSource, result);
            org.w3c.dom.Node transformedNode = result.getNode();
            if (transformedNode.getFirstChild().getNodeType() == 1) {
                return transformedNode;
            }
            xmlSource = new StreamSource(new StringReader(((XMLDocument)source).jsxGet_xml()));
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(xmlSource, streamResult);
            return writer.toString();
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("Exception: " + e));
        }
    }

    public DocumentFragment jsxFunction_transformToFragment(Node source, Object output) {
        SgmlPage page = (SgmlPage)((Document)((Object)output)).getDomNodeOrDie();
        DomDocumentFragment fragment = page.createDomDocumentFragment();
        DocumentFragment rv = new DocumentFragment();
        rv.setPrototype(this.getPrototype(((Object)((Object)rv)).getClass()));
        rv.setParentScope(this.getParentScope());
        rv.setDomNode(fragment);
        this.transform(page, source, fragment);
        return rv;
    }

    private void transform(SgmlPage page, Node source, DomNode parent) {
        Object result = this.transform(source);
        if (result instanceof org.w3c.dom.Node) {
            NodeList children = ((org.w3c.dom.Node)result).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                XmlUtil.appendChild(page, parent, children.item(i));
            }
        } else {
            DomText text = new DomText(page, (String)result);
            parent.appendDomChild(text);
        }
    }

    public void jsxFunction_setParameter(String namespaceURI, String localName, Object value) {
        this.parameters_.put(this.getQualifiedName(namespaceURI, localName), value);
    }

    public Object jsxFunction_getParameter(String namespaceURI, String localName) {
        return this.parameters_.get(this.getQualifiedName(namespaceURI, localName));
    }

    private String getQualifiedName(String namespaceURI, String localName) {
        String qualifiedName = namespaceURI != null && namespaceURI.length() != 0 && !namespaceURI.equals("null") ? '{' + namespaceURI + '}' + localName : localName;
        return qualifiedName;
    }

    public void jsxSet_input(Node input) {
        this.input_ = input;
    }

    public Node jsxGet_input() {
        return this.input_;
    }

    public void jsxSet_output(Object output) {
        this.output_ = output;
    }

    public Object jsxGet_output() {
        return this.output_;
    }

    public void jsxFunction_addParameter(String baseName, Object parameter, Object namespaceURI) {
        String nsString = namespaceURI instanceof String ? (String)namespaceURI : null;
        this.jsxFunction_setParameter(nsString, baseName, parameter);
    }

    public void jsxFunction_transform() {
        SgmlPage page = (SgmlPage)((Document)this.input_).getDomNodeOrDie();
        if (this.output_ == null) {
            DomDocumentFragment fragment = page.createDomDocumentFragment();
            DocumentFragment node = new DocumentFragment();
            node.setParentScope(this.getParentScope());
            node.setPrototype(this.getPrototype(((Object)((Object)node)).getClass()));
            node.setDomNode(fragment);
            this.output_ = (org.w3c.dom.Node)fragment.getScriptObject();
        }
        this.transform(page, this.input_, ((Node)((Object)this.output_)).getDomNodeOrDie());
        XMLSerializer serializer = new XMLSerializer();
        serializer.setParentScope(this.getParentScope());
        String output = "";
        Iterator it = ((Node)((Object)this.output_)).getDomNodeOrDie().getChildIterator();
        while (it.hasNext()) {
            DomNode child = (DomNode)it.next();
            if (child instanceof DomText) {
                if (((DomText)child).getData().trim().length() == 0) continue;
                output = output + ((DomText)child).getData();
                continue;
            }
            String serializedString = serializer.jsxFunction_serializeToString((Node)child.getScriptObject());
            output = output + serializedString.substring(0, serializedString.length() - 2);
        }
        this.output_ = output;
    }
}

