/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Style;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SelectorListImpl;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jaxen.JaxenException;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class Stylesheet
extends SimpleScriptable {
    private static final long serialVersionUID = -8341675386925348206L;
    private static final CSSOMParser PARSER = new CSSOMParser();
    private InputSource source_;
    private CSSStyleSheet wrapped_;

    public Stylesheet() {
        this(null);
    }

    public Stylesheet(InputSource source) {
        this.source_ = source;
    }

    private CSSStyleSheet getWrappedSheet() {
        if (this.wrapped_ == null) {
            this.wrapped_ = this.source_ != null ? this.parseCSS(this.source_) : new CSSStyleSheetImpl();
        }
        return this.wrapped_;
    }

    void modifyIfNecessary(Style style, HTMLElement element) {
        HtmlElement e = element.getHtmlElementOrDie();
        HtmlPage page = e.getPage();
        CSSRuleList rules = this.getWrappedSheet().getCssRules();
        if (rules == null) {
            return;
        }
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            if (rule.getType() != 1) continue;
            CSSStyleRule styleRule = (CSSStyleRule)rule;
            String s = styleRule.getSelectorText();
            SelectorList selectors = this.parseSelectors(new InputSource((Reader)new StringReader(s)));
            for (int j = 0; j < selectors.getLength(); ++j) {
                Selector selector = selectors.item(j);
                String xpath = this.translateToXPath(selector);
                if (xpath == null) continue;
                try {
                    List results = page.getByXPath(xpath);
                    if (!results.contains(e)) continue;
                    CSSStyleDeclaration dec = styleRule.getStyle();
                    for (int k = 0; k < dec.getLength(); ++k) {
                        String name = dec.item(k);
                        String value = dec.getPropertyValue(name);
                        style.setStyleAttribute(name, value);
                    }
                    continue;
                }
                catch (JaxenException je) {
                    this.getLog().error((Object)je.getMessage(), (Throwable)je);
                }
            }
        }
    }

    private CSSStyleSheet parseCSS(InputSource source) {
        CSSStyleSheet ss;
        try {
            ss = PARSER.parseStyleSheet(source);
        }
        catch (Exception e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
            ss = new CSSStyleSheetImpl();
        }
        return ss;
    }

    SelectorList parseSelectors(InputSource source) {
        SelectorList selectors;
        try {
            selectors = PARSER.parseSelectors(source);
        }
        catch (Exception e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
            selectors = new SelectorListImpl();
        }
        return selectors;
    }

    String translateToXPath(Selector selector) {
        String response;
        switch (selector.getSelectorType()) {
            case 1: {
                return "*";
            }
            case 6: {
                return null;
            }
            case 11: {
                DescendantSelector cs = (DescendantSelector)selector;
                String p = this.translateToXPath(cs.getAncestorSelector());
                String c = this.translateToXPath((Selector)cs.getSimpleSelector());
                response = p + "/" + c;
                break;
            }
            case 8: {
                return null;
            }
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                String e = this.translateToXPath((Selector)conditional.getSimpleSelector());
                String cond = this.translateToXPath(conditional.getCondition());
                if (cond != null) {
                    response = e + "[" + cond + "]";
                    break;
                }
                response = e;
                break;
            }
            case 10: {
                DescendantSelector ds = (DescendantSelector)selector;
                String a = this.translateToXPath(ds.getAncestorSelector());
                String d = this.translateToXPath((Selector)ds.getSimpleSelector());
                response = a + "//" + d;
                break;
            }
            case 12: {
                return null;
            }
            case 4: {
                ElementSelector es = (ElementSelector)selector;
                String name = es.getLocalName();
                if (name != null) {
                    response = "//" + name;
                    break;
                }
                response = "*";
                break;
            }
            case 3: {
                return null;
            }
            case 7: {
                return null;
            }
            case 9: {
                return null;
            }
            case 2: {
                return "html";
            }
            case 5: {
                return null;
            }
            default: {
                this.getLog().error((Object)("Unknown selector type '" + selector.getSelectorType() + "'."));
                return null;
            }
        }
        return response.replaceAll("/{3,}", "//");
    }

    private String translateToXPath(Condition condition) {
        switch (condition.getConditionType()) {
            case 0: {
                CombinatorCondition cc1 = (CombinatorCondition)condition;
                return "(" + this.translateToXPath(cc1.getFirstCondition()) + ") and (" + this.translateToXPath(cc1.getSecondCondition()) + ")";
            }
            case 4: {
                AttributeCondition ac1 = (AttributeCondition)condition;
                if (ac1.getSpecified()) {
                    return "@" + ac1.getLocalName() + " = '" + ac1.getValue() + "'";
                }
                return "@" + ac1.getLocalName();
            }
            case 8: {
                AttributeCondition ac2 = (AttributeCondition)condition;
                return "@" + ac2.getLocalName() + " = '" + ac2.getValue() + "' " + "or starts-with( @" + ac2.getLocalName() + ", concat( '" + ac2.getValue() + "', '-' ) )";
            }
            case 9: {
                AttributeCondition ac3 = (AttributeCondition)condition;
                return "contains( concat(' ', @class, ' '), concat(' ', '" + ac3.getValue() + "', ' ') )";
            }
            case 13: {
                return null;
            }
            case 5: {
                AttributeCondition ac4 = (AttributeCondition)condition;
                return "@id='" + ac4.getValue() + "'";
            }
            case 6: {
                return null;
            }
            case 2: {
                return null;
            }
            case 7: {
                AttributeCondition ac5 = (AttributeCondition)condition;
                return "contains( concat(' ', @" + ac5.getLocalName() + ", ' '), " + "concat(' ', '" + ac5.getValue() + "', ' ') )";
            }
            case 11: {
                return null;
            }
            case 12: {
                return null;
            }
            case 1: {
                CombinatorCondition cc2 = (CombinatorCondition)condition;
                return "(" + this.translateToXPath(cc2.getFirstCondition()) + ") or (" + this.translateToXPath(cc2.getSecondCondition()) + ")";
            }
            case 3: {
                return null;
            }
            case 10: {
                return null;
            }
        }
        return null;
    }
}

