/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClassConfiguration {
    private static final String GETTER_PREFIX = "jsxGet_";
    private static final String SETTER_PREFIX = "jsxSet_";
    private static final String FUNCTION_PREFIX = "jsxFunction_";
    private Map propertyMap_ = new HashMap();
    private Map functionMap_ = new HashMap();
    private List constants_ = new ArrayList();
    private String extendedClass_;
    private final String className_;
    private final Class linkedClass_;
    private final Method jsConstructor_;
    private final String htmlClassname_;
    private final boolean jsObject_;

    public ClassConfiguration(String classname, String implementingClass, String jsConstructor, String extendedClass, String htmlClass, boolean jsObject) throws ClassNotFoundException {
        this.className_ = classname;
        this.extendedClass_ = extendedClass;
        this.linkedClass_ = Class.forName(implementingClass);
        if (jsConstructor != null && jsConstructor.length() != 0) {
            Method foundCtor = null;
            Method[] methods = this.linkedClass_.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(jsConstructor)) continue;
                foundCtor = methods[i];
                break;
            }
            if (foundCtor == null) {
                throw new IllegalStateException("Constructor method \"" + jsConstructor + "\" in class \"" + implementingClass + " is not found.");
            }
            this.jsConstructor_ = foundCtor;
        } else {
            this.jsConstructor_ = null;
        }
        this.jsObject_ = jsObject;
        this.htmlClassname_ = htmlClass != null && htmlClass.length() != 0 ? htmlClass : null;
    }

    public String getClassName() {
        return this.className_;
    }

    public void addProperty(String name, boolean readable, boolean writeable) {
        PropertyInfo info = new PropertyInfo();
        info.setReadable(readable);
        info.setWriteable(writeable);
        try {
            if (readable) {
                info.setReadMethod(this.linkedClass_.getMethod(GETTER_PREFIX + name, null));
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Method 'jsxGet_" + name + "' was not found for " + name + " property in " + this.linkedClass_.getName());
        }
        if (writeable) {
            Method[] methods = this.linkedClass_.getMethods();
            String setMethodName = SETTER_PREFIX + name;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(setMethodName) || methods[i].getParameterTypes().length != 1) continue;
                info.setWriteMethod(methods[i]);
                break;
            }
            if (info.getWriteMethod() == null) {
                throw new IllegalStateException("Method 'jsxSet_" + name + "' was not found for " + name + " property in " + this.linkedClass_.getName());
            }
        }
        this.propertyMap_.put(name, info);
    }

    public void addConstant(String name) {
        this.constants_.add(name);
    }

    public Set propertyKeys() {
        return this.propertyMap_.keySet();
    }

    public Set functionKeys() {
        return this.functionMap_.keySet();
    }

    public List constants() {
        return this.constants_;
    }

    public void addFunction(String name) {
        FunctionInfo info = new FunctionInfo();
        Method[] methods = this.linkedClass_.getMethods();
        String setMethodName = FUNCTION_PREFIX + name;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(setMethodName)) continue;
            info.setFunctionMethod(methods[i]);
            break;
        }
        if (info.getFunctionMethod() == null) {
            throw new IllegalStateException("Method 'jsxFunction_" + name + "' was not found for " + name + " function in " + this.linkedClass_.getName());
        }
        this.functionMap_.put(name, info);
    }

    public void setBrowser(String propertyName, String browserName) throws IllegalStateException {
        PropertyInfo property = this.getPropertyInfo(propertyName);
        if (property == null) {
            throw new IllegalStateException("Property does not exist to set browser");
        }
        property.setBrowser(new BrowserInfo(browserName));
    }

    public String getExtendedClass() {
        return this.extendedClass_;
    }

    public void setExtendedClass(String extendedClass) {
        this.extendedClass_ = extendedClass;
    }

    protected PropertyInfo getPropertyInfo(String propertyName) {
        return (PropertyInfo)this.propertyMap_.get(propertyName);
    }

    private FunctionInfo getFunctionInfo(String functionName) {
        return (FunctionInfo)this.functionMap_.get(functionName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassConfiguration)) {
            return false;
        }
        ClassConfiguration config = (ClassConfiguration)obj;
        if (this.propertyMap_.size() != config.propertyMap_.size()) {
            return false;
        }
        if (this.functionMap_.size() != config.functionMap_.size()) {
            return false;
        }
        Set keys = config.propertyMap_.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (((PropertyInfo)config.propertyMap_.get(key)).valueEquals(this.propertyMap_.get(key))) continue;
            return false;
        }
        Set fkeys = config.functionMap_.keySet();
        Iterator fit = fkeys.iterator();
        while (fit.hasNext()) {
            String fkey = (String)fit.next();
            if (((FunctionInfo)config.functionMap_.get(fkey)).valueEquals(this.functionMap_.get(fkey))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.className_.hashCode();
    }

    public Method getPropertyReadMethod(String propertyName) {
        PropertyInfo info = this.getPropertyInfo(propertyName);
        if (info == null) {
            return null;
        }
        return info.getReadMethod();
    }

    public Method getPropertyWriteMethod(String propertyName) {
        PropertyInfo info = this.getPropertyInfo(propertyName);
        if (info == null) {
            return null;
        }
        return info.getWriteMethod();
    }

    public Method getFunctionMethod(String functionName) {
        FunctionInfo info = this.getFunctionInfo(functionName);
        if (info == null) {
            return null;
        }
        return info.getFunctionMethod();
    }

    public Class getLinkedClass() {
        return this.linkedClass_;
    }

    public Method getJsConstructor() {
        return this.jsConstructor_;
    }

    public String getHtmlClassname() {
        return this.htmlClassname_;
    }

    public boolean isJsObject() {
        return this.jsObject_;
    }

    private class BrowserInfo {
        private String browserName_;
        private String minVersion_;
        private String maxVersion_;
        private String lessThanVersion_;

        private boolean valueEquals(Object obj) {
            if (!(obj instanceof BrowserInfo)) {
                return false;
            }
            BrowserInfo info = (BrowserInfo)obj;
            if (this.minVersion_ != null && !this.minVersion_.equals(info.minVersion_)) {
                return false;
            }
            if (this.maxVersion_ != null && !this.maxVersion_.equals(info.maxVersion_)) {
                return false;
            }
            if (this.lessThanVersion_ != null && !this.lessThanVersion_.equals(info.lessThanVersion_)) {
                return false;
            }
            return this.browserName_ == info.browserName_;
        }

        public BrowserInfo(String browserName) {
            this.browserName_ = browserName;
        }

        private String getBrowserName() {
            return this.browserName_;
        }
    }

    private class FunctionInfo {
        private boolean hasBrowsers_ = false;
        private Map browserMap_;
        private Method functionMethod_;

        private FunctionInfo() {
        }

        private boolean valueEquals(Object obj) {
            if (!(obj instanceof FunctionInfo)) {
                return false;
            }
            FunctionInfo info = (FunctionInfo)obj;
            if (this.hasBrowsers_ != info.hasBrowsers_) {
                return false;
            }
            if (this.hasBrowsers_) {
                if (this.browserMap_.size() != info.browserMap_.size()) {
                    return false;
                }
                Set keys = this.browserMap_.keySet();
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (((BrowserInfo)this.browserMap_.get(key)).valueEquals(info.browserMap_.get(key))) continue;
                    return false;
                }
            }
            return true;
        }

        public Method getFunctionMethod() {
            return this.functionMethod_;
        }

        public void setFunctionMethod(Method functionMethod) {
            this.functionMethod_ = functionMethod;
        }
    }

    protected class PropertyInfo {
        private boolean readable_ = false;
        private boolean writeable_ = false;
        private boolean hasBrowsers_ = false;
        private Map browserMap_;
        private Method readMethod_;
        private Method writeMethod_;

        protected PropertyInfo() {
        }

        public Method getReadMethod() {
            return this.readMethod_;
        }

        public void setReadMethod(Method readMethod) {
            this.readMethod_ = readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod_;
        }

        public void setWriteMethod(Method writeMethod) {
            this.writeMethod_ = writeMethod;
        }

        private void setBrowser(BrowserInfo browserInfo) {
            if (this.browserMap_ == null) {
                this.hasBrowsers_ = true;
                this.browserMap_ = new HashMap();
            }
            this.browserMap_.put(browserInfo.getBrowserName(), browserInfo);
        }

        private boolean valueEquals(Object obj) {
            if (!(obj instanceof PropertyInfo)) {
                return false;
            }
            PropertyInfo info = (PropertyInfo)obj;
            if (this.hasBrowsers_ != info.hasBrowsers_) {
                return false;
            }
            if (this.hasBrowsers_) {
                if (this.browserMap_.size() != info.browserMap_.size()) {
                    return false;
                }
                Set keys = this.browserMap_.keySet();
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (((BrowserInfo)this.browserMap_.get(key)).valueEquals(info.browserMap_.get(key))) continue;
                    return false;
                }
            }
            return this.readable_ == info.readable_ && this.writeable_ == info.writeable_;
        }

        private void setReadable(boolean readable) {
            this.readable_ = readable;
        }

        private void setWriteable(boolean writeable) {
            this.writeable_ = writeable;
        }
    }
}

