/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import java.lang.reflect.Field;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class StringPrimitivePrototypeBugFixer
implements Scriptable {
    private static final Field FieldPrototypeProperty_;
    private static final Field FieldContextLastInterpreterFrame_;
    private static Field FieldInterpreterCallFrameScope_;
    private final Scriptable wrapped_;

    static void installWorkaround(Scriptable topScope) throws Exception {
        BaseFunction stringObj = (BaseFunction)topScope.get("String", topScope);
        Scriptable stringObjPrototype = (Scriptable)FieldPrototypeProperty_.get(stringObj);
        StringPrimitivePrototypeBugFixer prototypeWrapper = new StringPrimitivePrototypeBugFixer(stringObjPrototype);
        FieldPrototypeProperty_.set(stringObj, prototypeWrapper);
    }

    StringPrimitivePrototypeBugFixer(Scriptable wrapped) {
        this.wrapped_ = wrapped;
    }

    public void delete(int index) {
        this.wrapped_.delete(index);
    }

    public void delete(String name) {
        this.wrapped_.delete(name);
    }

    public Object get(int index, Scriptable start) {
        if (start == this) {
            start = this.wrapped_;
        }
        return this.wrapped_.get(index, start);
    }

    private Scriptable getRealScope() throws Exception {
        Object o = FieldContextLastInterpreterFrame_.get(Context.getCurrentContext());
        if (FieldInterpreterCallFrameScope_ == null) {
            FieldInterpreterCallFrameScope_ = o.getClass().getDeclaredField("scope");
            FieldInterpreterCallFrameScope_.setAccessible(true);
        }
        return (Scriptable)FieldInterpreterCallFrameScope_.get(o);
    }

    public Object get(String name, Scriptable start) {
        try {
            Scriptable originalScope = this.getRealScope();
            Scriptable originalTopScope = ScriptableObject.getTopLevelScope((Scriptable)originalScope);
            Scriptable currentTopScope = ScriptableObject.getTopLevelScope((Scriptable)this);
            if (originalTopScope != currentTopScope) {
                Scriptable s = (Scriptable)originalTopScope.get("String", originalTopScope);
                Scriptable p = (Scriptable)s.get("prototype", s);
                return p.get(name, p);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (start == this) {
            start = this.wrapped_;
        }
        return this.wrapped_.get(name, start);
    }

    public String getClassName() {
        return this.wrapped_.getClassName();
    }

    public Object getDefaultValue(Class hint) {
        return this.wrapped_.getDefaultValue(hint);
    }

    public Object[] getIds() {
        return this.wrapped_.getIds();
    }

    public Scriptable getParentScope() {
        return this.wrapped_.getParentScope();
    }

    public Scriptable getPrototype() {
        return this.wrapped_.getPrototype();
    }

    public boolean has(int index, Scriptable start) {
        if (start == this) {
            start = this.wrapped_;
        }
        return this.wrapped_.has(index, start);
    }

    public boolean has(String name, Scriptable start) {
        if (start == this) {
            start = this.wrapped_;
        }
        return this.wrapped_.has(name, start);
    }

    public boolean hasInstance(Scriptable instance) {
        return this.wrapped_.hasInstance(instance);
    }

    public void put(int index, Scriptable start, Object value) {
        if (start == this) {
            start = this.wrapped_;
        }
        this.wrapped_.put(index, start, value);
    }

    public void put(String name, Scriptable start, Object value) {
        if (start == this) {
            start = this.wrapped_;
        }
        this.wrapped_.put(name, start, value);
    }

    public void setParentScope(Scriptable parent) {
        this.wrapped_.setParentScope(parent);
    }

    public void setPrototype(Scriptable prototype) {
        this.wrapped_.setPrototype(prototype);
    }

    static {
        try {
            FieldPrototypeProperty_ = BaseFunction.class.getDeclaredField("prototypeProperty");
            FieldPrototypeProperty_.setAccessible(true);
            FieldContextLastInterpreterFrame_ = Context.class.getDeclaredField("lastInterpreterFrame");
            FieldContextLastInterpreterFrame_.setAccessible(true);
        }
        catch (Exception e) {
            throw new Error("Bad Rhino version: can't install custom String primitive prototype fix");
        }
    }
}

