/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;

public class DebugFrameImpl
implements DebugFrame {
    private static final Log LOG = LogFactory.getLog((Class)DebugFrameImpl.class);
    private final DebuggableScript functionOrScript_;

    public DebugFrameImpl(DebuggableScript functionOrScript) {
        this.functionOrScript_ = functionOrScript;
    }

    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        if (LOG.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer();
            for (Scriptable parent = activation.getParentScope(); parent != null; parent = parent.getParentScope()) {
                sb.append("   ");
            }
            sb.append(this.getFunctionName(thisObj)).append("(");
            for (int i = 0; i < args.length; ++i) {
                sb.append(this.getParamName(i)).append(" : ").append(args[i]);
                if (i >= args.length - 1) continue;
                sb.append(", ");
            }
            sb.append(") @ line ").append(this.getFirstLine());
            sb.append(" of ").append(this.getSourceName());
            LOG.trace((Object)sb);
        }
    }

    public void onExceptionThrown(Context cx, Throwable t) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Throwing exception: " + t.getMessage()), t);
        }
    }

    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
    }

    public void onLineChange(Context cx, int lineNumber) {
    }

    private String getFunctionName(Scriptable thisObj) {
        if (this.functionOrScript_.isFunction()) {
            String name = this.functionOrScript_.getFunctionName();
            if (name != null && name.length() > 0) {
                return name;
            }
            Object[] ids = thisObj.getIds();
            for (int i = 0; i < ids.length; ++i) {
                NativeFunction f;
                String s;
                Object o;
                Object id = ids[i];
                if (!(id instanceof String) || !((o = thisObj.get(s = (String)id, thisObj)) instanceof NativeFunction) || (f = (NativeFunction)o).getDebuggableView() != this.functionOrScript_) continue;
                return s;
            }
            return "[anonymous]";
        }
        return "[script]";
    }

    private String getParamName(int index) {
        if (index >= 0 && this.functionOrScript_.getParamCount() > index) {
            return this.functionOrScript_.getParamOrVarName(index);
        }
        return "???";
    }

    private String getSourceName() {
        return this.functionOrScript_.getSourceName().trim();
    }

    private String getFirstLine() {
        int first = Integer.MAX_VALUE;
        int[] lines = this.functionOrScript_.getLineNumbers();
        for (int i = 0; i < lines.length; ++i) {
            int current = lines[i];
            if (current >= first) continue;
            first = current;
        }
        if (first != Integer.MAX_VALUE) {
            return String.valueOf(first);
        }
        return "???";
    }
}

