/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Script;
import java.util.Map;
import org.mozilla.javascript.Function;

public class HtmlScript
extends HtmlElement {
    private static final long serialVersionUID = 5736570536821513938L;
    public static final String TAG_NAME = "script";
    private static final String SLASH_SLASH_COLON = "//:";
    private static int EventHandlerId_;

    public HtmlScript(HtmlPage page, Map attributes) {
        this(null, TAG_NAME, page, attributes);
    }

    HtmlScript(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public final String getCharsetAttribute() {
        return this.getAttributeValue("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttributeValue("type");
    }

    public final String getLanguageAttribute() {
        return this.getAttributeValue("language");
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final String getEventAttribute() {
        return this.getAttributeValue("event");
    }

    public final String getHtmlForAttribute() {
        return this.getAttributeValue("for");
    }

    public final String getDeferAttribute() {
        return this.getAttributeValue("defer");
    }

    public DomNode appendDomChild(DomNode node) {
        DomNode response = super.appendDomChild(node);
        this.executeInlineScriptIfNeeded(false);
        return response;
    }

    protected void onAddedToPage() {
        this.getLog().debug((Object)("Script node added: " + this.asXml()));
        this.executeOnReadyStateChangeHandlerIfNecessary();
        this.executeScriptIfNeeded(true);
        super.onAddedToPage();
    }

    private void executeInlineScriptIfNeeded(boolean executeIfDeferred) {
        String scriptCode;
        if (!this.isExecutionNeeded()) {
            return;
        }
        String defer = this.getDeferAttribute();
        boolean ie = this.getPage().getWebClient().getBrowserVersion().isIE();
        if (!executeIfDeferred && defer != ATTRIBUTE_NOT_DEFINED && ie) {
            return;
        }
        String src = this.getSrcAttribute();
        if (src != HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            return;
        }
        DomCharacterData textNode = (DomCharacterData)this.getFirstDomChild();
        String forr = this.getHtmlForAttribute();
        String event = this.getEventAttribute();
        if (event != ATTRIBUTE_NOT_DEFINED && forr != ATTRIBUTE_NOT_DEFINED) {
            if (event.endsWith("()")) {
                event = event.substring(0, event.length() - 2);
            }
            String handler = forr + "." + event;
            String functionName = "htmlunit_event_handler_JJLL" + EventHandlerId_;
            scriptCode = "function " + functionName + "()\n" + "{" + textNode.getData() + "}\n" + handler + "=" + functionName + ";";
        } else {
            scriptCode = textNode.getData();
        }
        String url = this.getPage().getWebResponse().getUrl().toExternalForm();
        int line1 = this.getStartLineNumber();
        int line2 = this.getEndLineNumber();
        int col1 = this.getStartColumnNumber();
        int col2 = this.getEndColumnNumber();
        String desc = "script in " + url + " from (" + line1 + ", " + col1 + ") to (" + line2 + ", " + col2 + ")";
        this.getPage().executeJavaScriptIfPossible(scriptCode, desc, line1);
    }

    void executeScriptIfNeeded(boolean executeIfDeferred) {
        if (!this.isExecutionNeeded()) {
            return;
        }
        String defer = this.getDeferAttribute();
        boolean ie = this.getPage().getWebClient().getBrowserVersion().isIE();
        if (!executeIfDeferred && defer != ATTRIBUTE_NOT_DEFINED && ie) {
            return;
        }
        String src = this.getSrcAttribute();
        if (src.equals(SLASH_SLASH_COLON)) {
            return;
        }
        if (src != ATTRIBUTE_NOT_DEFINED) {
            this.getLog().debug((Object)("Loading external javascript: " + src));
            this.getPage().loadExternalJavaScriptFile(src, this.getCharsetAttribute());
        } else if (this.getFirstDomChild() != null) {
            this.executeInlineScriptIfNeeded(executeIfDeferred);
        }
    }

    private boolean isExecutionNeeded() {
        HtmlPage page = this.getPage();
        if (!page.getWebClient().isJavaScriptEnabled()) {
            return false;
        }
        for (DomNode o = this; o != null; o = o.getParentDomNode()) {
            if (!(o instanceof HtmlInlineFrame) && !(o instanceof HtmlNoFrames) && !(o instanceof HtmlNoScript)) continue;
            return false;
        }
        if (page.getEnclosingWindow() != null && page.getEnclosingWindow().getEnclosedPage() != page) {
            return false;
        }
        if (!HtmlPage.isJavaScript(this.getTypeAttribute(), this.getLanguageAttribute())) {
            String t = this.getTypeAttribute();
            String l = this.getLanguageAttribute();
            this.getLog().warn((Object)("Script is not javascript (type: " + t + ", language: " + l + "). Skipping execution."));
            return false;
        }
        DomNode root = this;
        while (root.getParentDomNode() != null) {
            root = root.getParentDomNode();
        }
        return root == this.getPage();
    }

    private void executeOnReadyStateChangeHandlerIfNecessary() {
        if (this.getPage().getWebClient().getBrowserVersion().isIE()) {
            this.setReadyState("complete");
            Script script = (Script)this.getScriptObject();
            Function handler = script.getOnReadyStateChangeHandler();
            if (handler != null) {
                this.getPage().executeJavaScriptFunctionIfPossible(handler, script, new Object[0], this);
            }
        }
    }

    public String asText() {
        return "";
    }

    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }
}

