/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Map;

public class HtmlRadioButtonInput
extends HtmlInput {
    private static final long serialVersionUID = 425993174633373218L;
    private boolean defaultCheckedState_;

    public HtmlRadioButtonInput(HtmlPage page, Map attributes) {
        this(null, "input", page, attributes);
    }

    HtmlRadioButtonInput(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if (this.getAttributeValue("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setAttributeValue("value", "on");
        }
        this.defaultCheckedState_ = this.isAttributeDefined("checked");
    }

    public void reset() {
        if (this.defaultCheckedState_) {
            this.setAttributeValue("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
    }

    public Page setChecked(boolean isChecked) {
        ScriptResult scriptResult;
        boolean changed;
        HtmlForm form = this.getEnclosingForm();
        boolean bl = changed = this.isChecked() != isChecked;
        if (isChecked) {
            if (form != null) {
                form.setCheckedRadioButton(this);
            } else {
                this.getPage().setCheckedRadioButton(this);
            }
        } else {
            this.removeAttribute("checked");
        }
        Page page = this.getPage();
        if (changed && (scriptResult = this.fireEvent("change")) != null) {
            page = scriptResult.getNewPage();
        }
        return page;
    }

    public String asText() {
        if (this.isChecked()) {
            return "checked";
        }
        return "unchecked";
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        this.setChecked(true);
        return defaultPage;
    }

    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        if (this.getPage().getWebClient().getBrowserVersion().isNetscape()) {
            this.setChecked(defaultChecked);
        }
    }

    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }

    protected boolean isStateUpdateFirst() {
        return true;
    }
}

