/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.OnbeforeunloadHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlBase;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlLegend;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public final class HtmlPage
extends SgmlPage
implements Cloneable {
    private static final long serialVersionUID = 1779746292119944291L;
    private String originalCharset_;
    private Map idMap_ = new HashMap();
    private Map nameMap_ = new HashMap();
    private HtmlElement documentElement_;
    private HtmlElement elementWithFocus_;
    private final transient Log javascriptLog_ = LogFactory.getLog((String)"com.gargoylesoftware.htmlunit.javascript");
    private List attributeListeners_;
    private final transient Object lock_ = new Object();

    public HtmlPage(URL originatingUrl, WebResponse webResponse, WebWindow webWindow) {
        super(webResponse, webWindow);
    }

    public HtmlPage getPage() {
        return this;
    }

    public void initialize() throws IOException, FailingHttpStatusCodeException {
        this.loadFrames();
        this.getDocumentHtmlElement().setReadyState("complete");
        if (!this.getWebClient().getBrowserVersion().isIE()) {
            this.executeEventHandlersIfNeeded("DOMContentLoaded");
        }
        this.executeDeferredScriptsIfNeeded();
        this.executeEventHandlersIfNeeded("load");
        this.executeRefreshIfNeeded();
    }

    public void cleanUp() throws IOException {
        this.executeEventHandlersIfNeeded("unload");
        this.deregisterFramesIfNeeded();
    }

    public HtmlElement getDocumentElement() {
        return this.getDocumentHtmlElement();
    }

    public HtmlElement getDocumentHtmlElement() {
        if (this.documentElement_ == null) {
            DomNode childNode;
            for (childNode = this.getFirstDomChild(); childNode != null && !(childNode instanceof HtmlElement); childNode = childNode.getNextDomSibling()) {
            }
            this.documentElement_ = (HtmlElement)childNode;
        }
        return this.documentElement_;
    }

    public String getPageEncoding() {
        if (this.originalCharset_ != null) {
            return this.originalCharset_;
        }
        List list = this.getMetaTags("content-type");
        for (int i = 0; i < list.size(); ++i) {
            HtmlMeta meta = (HtmlMeta)list.get(i);
            String contents = meta.getContentAttribute();
            int pos = contents.toLowerCase().indexOf("charset=");
            if (pos < 0) continue;
            this.originalCharset_ = contents.substring(pos + 8);
            this.getLog().debug((Object)("Page Encoding detected: " + this.originalCharset_));
            return this.originalCharset_;
        }
        if (this.originalCharset_ == null) {
            this.originalCharset_ = this.getWebResponse().getContentCharSet();
        }
        return this.originalCharset_;
    }

    public HtmlElement createElement(String tagName) {
        return this.createHtmlElement(tagName);
    }

    public HtmlElement createHtmlElement(String tagName) {
        String tagLower = tagName.toLowerCase();
        return HTMLParser.getFactory(tagLower).createElement(this, tagLower, null);
    }

    public HtmlElement createElementNS(String namespaceURI, String qualifiedName) {
        return this.createHtmlElementNS(namespaceURI, qualifiedName);
    }

    public HtmlElement createHtmlElementNS(String namespaceURI, String qualifiedName) {
        String tagLower = qualifiedName.toLowerCase().substring(qualifiedName.indexOf(58) + 1);
        return HTMLParser.getFactory(tagLower).createElementNS(this, namespaceURI, qualifiedName, null);
    }

    public HtmlAnchor getAnchorByName(String name) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentHtmlElement().getOneHtmlElementByAttribute("a", "name", name);
    }

    public HtmlAnchor getAnchorByHref(String href) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentHtmlElement().getOneHtmlElementByAttribute("a", "href", href);
    }

    public List getAnchors() {
        return this.getDocumentHtmlElement().getHtmlElementsByTagNames(Collections.singletonList("a"));
    }

    public HtmlAnchor getFirstAnchorByText(String text) throws ElementNotFoundException {
        Assert.notNull("text", text);
        Iterator iterator = this.getAnchors().iterator();
        while (iterator.hasNext()) {
            HtmlAnchor anchor = (HtmlAnchor)iterator.next();
            if (!text.equals(anchor.asText())) continue;
            return anchor;
        }
        throw new ElementNotFoundException("a", "<text>", text);
    }

    public HtmlForm getFormByName(String name) throws ElementNotFoundException {
        List forms = this.getDocumentHtmlElement().getHtmlElementsByAttribute("form", "name", name);
        if (forms.size() == 0) {
            throw new ElementNotFoundException("form", "name", name);
        }
        return (HtmlForm)forms.get(0);
    }

    public List getForms() {
        return this.getDocumentHtmlElement().getHtmlElementsByTagNames(Arrays.asList("form"));
    }

    public URL getFullyQualifiedUrl(String relativeUrl) throws MalformedURLException {
        URL baseUrl;
        List baseElements = this.getDocumentHtmlElement().getHtmlElementsByTagName("base");
        if (baseElements.isEmpty()) {
            baseUrl = this.getWebResponse().getUrl();
        } else {
            if (baseElements.size() > 1) {
                this.notifyIncorrectness("Multiple 'base' detected, only the first is used.");
            }
            HtmlBase htmlBase = (HtmlBase)baseElements.get(0);
            boolean insideHead = false;
            for (DomNode parent = htmlBase.getParentDomNode(); parent != null; parent = parent.getParentDomNode()) {
                if (!(parent instanceof HtmlHead)) continue;
                insideHead = true;
                break;
            }
            if (!insideHead) {
                this.notifyIncorrectness("Element 'base' must appear in <head>, it is ignored.");
            }
            String href = htmlBase.getHrefAttribute();
            if (!insideHead || StringUtils.isEmpty((String)href)) {
                baseUrl = this.getWebResponse().getUrl();
            } else {
                try {
                    baseUrl = new URL(href);
                }
                catch (MalformedURLException e) {
                    this.notifyIncorrectness("Invalid base url: \"" + href + "\", ignoring it");
                    baseUrl = this.getWebResponse().getUrl();
                }
            }
        }
        if (this.getWebClient().getBrowserVersion().isNetscape()) {
            boolean incorrectnessNotified = false;
            while (relativeUrl.startsWith("http:") && !relativeUrl.startsWith("http://")) {
                if (!incorrectnessNotified) {
                    this.notifyIncorrectness("Incorrect URL \"" + relativeUrl + "\" has been corrected");
                    incorrectnessNotified = true;
                }
                relativeUrl = "http:/" + relativeUrl.substring(5);
            }
        }
        return WebClient.expandUrl(baseUrl, relativeUrl);
    }

    public String getResolvedTarget(String elementTarget) {
        String resolvedTarget;
        List baseElements = this.getDocumentHtmlElement().getHtmlElementsByTagNames(Collections.singletonList("base"));
        if (baseElements.isEmpty()) {
            resolvedTarget = elementTarget;
        } else if (elementTarget != null && elementTarget.length() > 0) {
            resolvedTarget = elementTarget;
        } else {
            HtmlBase htmlBase = (HtmlBase)baseElements.get(0);
            resolvedTarget = htmlBase.getTargetAttribute();
        }
        return resolvedTarget;
    }

    public List getTabbableElementIds() {
        ArrayList<String> list = new ArrayList<String>(this.getTabbableElements());
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            list.set(i, ((HtmlElement)list.get(i)).getAttributeValue("id"));
        }
        return Collections.unmodifiableList(list);
    }

    public List getTabbableElements() {
        List<Object> tags = Arrays.asList("a", "area", "button", "input", "object", "select", "textarea");
        ArrayList<HtmlElement> tabbableElements = new ArrayList<HtmlElement>();
        Iterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            boolean disabled;
            HtmlElement element = (HtmlElement)iterator.next();
            String tagName = element.getTagName();
            if (!tags.contains(tagName) || (disabled = element.isAttributeDefined("disabled")) || element.getTabIndex() == HtmlElement.TAB_INDEX_OUT_OF_BOUNDS) continue;
            tabbableElements.add(element);
        }
        Collections.sort(tabbableElements, this.createTabOrderComparator());
        return Collections.unmodifiableList(tabbableElements);
    }

    private Comparator createTabOrderComparator() {
        return new Comparator(){

            public int compare(Object object1, Object object2) {
                HtmlElement element1 = (HtmlElement)object1;
                HtmlElement element2 = (HtmlElement)object2;
                Short i1 = element1.getTabIndex();
                Short i2 = element2.getTabIndex();
                int index1 = i1 != null ? (int)i1.shortValue() : -1;
                int index2 = i2 != null ? (int)i2.shortValue() : -1;
                int result = index1 > 0 && index2 > 0 ? index1 - index2 : (index1 > 0 ? -1 : (index2 > 0 ? 1 : (index1 == index2 ? 0 : index2 - index1)));
                return result;
            }
        };
    }

    public HtmlElement getHtmlElementByAccessKey(char accessKey) {
        List elements = this.getHtmlElementsByAccessKey(accessKey);
        if (elements.isEmpty()) {
            return null;
        }
        return (HtmlElement)elements.get(0);
    }

    public List getHtmlElementsByAccessKey(char accessKey) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        String searchString = ("" + accessKey).toLowerCase();
        List<Object> acceptableTagNames = Arrays.asList("a", "area", "button", "input", "label", "legend", "textarea");
        Iterator iterator = this.getAllHtmlChildElements();
        while (iterator.hasNext()) {
            String accessKeyAttribute;
            HtmlElement element = (HtmlElement)iterator.next();
            if (!acceptableTagNames.contains(element.getTagName()) || !searchString.equalsIgnoreCase(accessKeyAttribute = element.getAttributeValue("accesskey"))) continue;
            elements.add(element);
        }
        return elements;
    }

    public void assertAllTabIndexAttributesSet() {
        WebAssert.assertAllTabIndexAttributesSet(this);
    }

    public void assertAllAccessKeyAttributesUnique() {
        WebAssert.assertAllAccessKeyAttributesUnique(this);
    }

    public void assertAllIdAttributesUnique() {
        WebAssert.assertAllIdAttributesUnique(this);
    }

    public ScriptResult executeJavaScript(String sourceCode) {
        return this.executeJavaScriptIfPossible(sourceCode, "injected script", 1);
    }

    public ScriptResult executeJavaScriptIfPossible(String sourceCode, String sourceName, HtmlElement htmlElement) {
        return this.executeJavaScriptIfPossible(sourceCode, sourceName, 1);
    }

    public ScriptResult executeJavaScriptIfPossible(String sourceCode, String sourceName, int startLine) {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return new ScriptResult(null, this);
        }
        String prefix = "javascript:";
        int prefixLength = "javascript:".length();
        if (sourceCode.length() > prefixLength && sourceCode.substring(0, prefixLength).equalsIgnoreCase("javascript:")) {
            sourceCode = sourceCode.substring(prefixLength);
        }
        WebWindow window = this.getEnclosingWindow();
        this.getWebClient().pushClearFirstWindow();
        Object result = this.getWebClient().getJavaScriptEngine().execute(this, sourceCode, sourceName, startLine);
        WebWindow firstWindow = this.getWebClient().popFirstWindow();
        if (firstWindow == null) {
            firstWindow = window;
        }
        return new ScriptResult(result, firstWindow.getEnclosedPage());
    }

    public ScriptResult executeJavaScriptFunctionIfPossible(Function function, Scriptable thisObject, Object[] args, DomNode htmlElementScope) {
        WebWindow window = this.getEnclosingWindow();
        this.getWebClient().pushClearFirstWindow();
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return new ScriptResult(null, this);
        }
        JavaScriptEngine engine = this.getWebClient().getJavaScriptEngine();
        Object result = engine.callFunction(this, function, thisObject, args, htmlElementScope);
        WebWindow firstWindow = this.getWebClient().popFirstWindow();
        if (firstWindow == null) {
            firstWindow = window;
        }
        return new ScriptResult(result, firstWindow.getEnclosedPage());
    }

    protected Log getJsLog() {
        return this.javascriptLog_;
    }

    void loadExternalJavaScriptFile(String srcAttribute, String charset) {
        if (this.getWebClient().isJavaScriptEnabled()) {
            URL scriptURL;
            try {
                scriptURL = this.getFullyQualifiedUrl(srcAttribute);
                if (scriptURL.getProtocol().equals("javascript")) {
                    this.getLog().info((Object)("Ignoring script src [" + srcAttribute + "]"));
                    return;
                }
            }
            catch (MalformedURLException e) {
                this.getLog().error((Object)("Unable to build url for script src tag [" + srcAttribute + "]"));
                if (this.getWebClient().isThrowExceptionOnScriptError()) {
                    throw new ScriptException(this, (Throwable)e);
                }
                return;
            }
            Script script = this.loadJavaScriptFromUrl(scriptURL, charset);
            if (script != null) {
                this.getWebClient().getJavaScriptEngine().execute(this, script);
            }
        }
    }

    public static boolean isJavaScript(String typeAttribute, String languageAttribute) {
        boolean isJavaScript = languageAttribute != null && languageAttribute.length() != 0 ? TextUtil.startsWithIgnoreCase(languageAttribute, "javascript") : (typeAttribute != null && typeAttribute.length() != 0 ? typeAttribute.equalsIgnoreCase("text/javascript") : true);
        return isJavaScript;
    }

    private Script loadJavaScriptFromUrl(URL url, String charset) {
        boolean successful;
        WebResponse webResponse;
        String scriptEncoding = charset;
        this.getPageEncoding();
        try {
            WebRequestSettings requestSettings = new WebRequestSettings(url);
            webResponse = this.getWebClient().loadWebResponse(requestSettings);
        }
        catch (IOException e) {
            this.getLog().error((Object)("Error loading JavaScript from [" + url.toExternalForm() + "]."), (Throwable)e);
            return null;
        }
        JavaScriptEngine javaScriptEngine = this.getWebClient().getJavaScriptEngine();
        Script cachedScript = javaScriptEngine.getCachedScript(webResponse);
        if (cachedScript != null) {
            return cachedScript;
        }
        this.getWebClient().printContentIfNecessary(webResponse);
        this.getWebClient().throwFailingHttpStatusCodeExceptionIfNecessary(webResponse);
        int statusCode = webResponse.getStatusCode();
        boolean bl = successful = statusCode >= 200 && statusCode < 300;
        if (!successful) {
            return null;
        }
        String contentType = webResponse.getContentType();
        if (!contentType.equalsIgnoreCase("text/javascript") && !contentType.equalsIgnoreCase("application/x-javascript")) {
            this.getLog().warn((Object)("Expected content type of 'text/javascript' or 'application/x-javascript' for remotely loaded JavaScript element at '" + url + "', " + "but got '" + contentType + "'."));
        }
        if (StringUtils.isEmpty((String)scriptEncoding)) {
            String contentCharset = webResponse.getContentCharSet();
            scriptEncoding = !contentCharset.equals("ISO-8859-1") ? contentCharset : (!this.originalCharset_.equals("ISO-8859-1") ? this.originalCharset_ : "ISO-8859-1");
        }
        byte[] data = webResponse.getResponseBody();
        String scriptCode = EncodingUtil.getString((byte[])data, (int)0, (int)data.length, (String)scriptEncoding);
        Script script = javaScriptEngine.compile(this, scriptCode, url.toExternalForm(), 1);
        javaScriptEngine.cacheScript(webResponse, script);
        return script;
    }

    public String getTitleText() {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement != null) {
            return titleElement.asText();
        }
        return "";
    }

    public void setTitleText(String message) {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement == null) {
            this.getLog().debug((Object)"No title element, creating one");
            HtmlHead head = (HtmlHead)this.getFirstChildElement(this.getDocumentHtmlElement(), HtmlHead.class);
            if (head == null) {
                throw new IllegalStateException("Headelement was not defined for this page");
            }
            titleElement = new HtmlTitle(null, "title", this, Collections.EMPTY_MAP);
            if (head.getFirstDomChild() != null) {
                head.getFirstDomChild().insertBefore(titleElement);
            } else {
                head.appendDomChild(titleElement);
            }
        }
        titleElement.setNodeValue(message);
    }

    private HtmlElement getFirstChildElement(HtmlElement startElement, Class clazz) {
        Iterator iterator = startElement.getChildElementsIterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!clazz.isInstance(element)) continue;
            return element;
        }
        return null;
    }

    private HtmlTitle getTitleElement() {
        HtmlHead head = (HtmlHead)this.getFirstChildElement(this.getDocumentHtmlElement(), HtmlHead.class);
        if (head != null) {
            return (HtmlTitle)this.getFirstChildElement(head, HtmlTitle.class);
        }
        return null;
    }

    private boolean executeEventHandlersIfNeeded(String eventType) {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return true;
        }
        Window jsWindow = (Window)this.getEnclosingWindow().getScriptObject();
        if (jsWindow != null) {
            HtmlElement element = this.getDocumentHtmlElement();
            Event event = new Event(element, eventType);
            element.fireEvent(event);
            if (!this.isOnbeforeunloadAccepted(this, event)) {
                return false;
            }
        }
        List frames = this.getDocumentHtmlElement().getHtmlElementsByTagNames(Arrays.asList("frame", "iframe"));
        Iterator iter = frames.iterator();
        while (iter.hasNext()) {
            BaseFrame frame = (BaseFrame)iter.next();
            Function frameTagEventHandler = frame.getEventHandler("on" + eventType);
            if (frameTagEventHandler == null) continue;
            this.getLog().debug((Object)("Executing on" + eventType + " handler for " + frame));
            Event event = new Event(frame, eventType);
            ((Node)frame.getScriptObject()).executeEvent(event);
            if (this.isOnbeforeunloadAccepted(frame.getPage(), event)) continue;
            return false;
        }
        return true;
    }

    private boolean isOnbeforeunloadAccepted(HtmlPage page, Event event) {
        if (event.jsxGet_type().equals("beforeunload") && event.jsxGet_returnValue() != null) {
            OnbeforeunloadHandler handler = this.getWebClient().getOnbeforeunloadHandler();
            if (handler == null) {
                this.getLog().warn((Object)"document.onbeforeunload() returned a string in event.returnValue, but no onbeforeunload handler installed.");
            } else {
                String message = Context.toString((Object)event.jsxGet_returnValue());
                return handler.handleEvent(page, message);
            }
        }
        return true;
    }

    private void executeRefreshIfNeeded() throws IOException {
        URL url;
        int time;
        boolean timeOnly;
        WebWindow window = this.getEnclosingWindow();
        if (window == null) {
            return;
        }
        String refreshString = this.getRefreshStringOrNull();
        if (refreshString == null || refreshString.length() == 0) {
            return;
        }
        int index = refreshString.indexOf(";");
        boolean bl = timeOnly = index == -1;
        if (timeOnly) {
            try {
                time = Integer.parseInt(refreshString);
            }
            catch (NumberFormatException e) {
                this.getLog().error((Object)("Malformed refresh string (no ';' but not a number): " + refreshString), (Throwable)e);
                return;
            }
            url = this.getWebResponse().getUrl();
        } else {
            try {
                time = Integer.parseInt(refreshString.substring(0, index).trim());
            }
            catch (NumberFormatException e) {
                this.getLog().error((Object)("Malformed refresh string (no valid number before ';') " + refreshString), (Throwable)e);
                return;
            }
            index = refreshString.indexOf("URL=", index);
            if (index == -1) {
                index = refreshString.indexOf("url=", index);
            }
            if (index == -1) {
                this.getLog().error((Object)("Malformed refresh string (found ';' but no 'url='): " + refreshString));
                return;
            }
            StringBuffer buffer = new StringBuffer(refreshString.substring(index + 4));
            if (buffer.toString().trim().length() == 0) {
                url = this.getWebResponse().getUrl();
            } else {
                if (buffer.charAt(0) == '\"' || buffer.charAt(0) == '\'') {
                    buffer.deleteCharAt(0);
                }
                if (buffer.charAt(buffer.length() - 1) == '\"' || buffer.charAt(buffer.length() - 1) == '\'') {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                String urlString = buffer.toString();
                try {
                    url = this.getFullyQualifiedUrl(urlString);
                }
                catch (MalformedURLException e) {
                    this.getLog().error((Object)("Malformed url in refresh string: " + refreshString), (Throwable)e);
                    throw e;
                }
            }
        }
        this.getWebClient().getRefreshHandler().handleRefresh(this, url, time);
    }

    private String getRefreshStringOrNull() {
        Iterator iterator = this.getMetaTags("refresh").iterator();
        boolean javaScriptEnabled = this.getWebClient().isJavaScriptEnabled();
        while (iterator.hasNext()) {
            HtmlMeta meta = (HtmlMeta)iterator.next();
            if (javaScriptEnabled && this.getFirstParent(meta, "noscript") != null) continue;
            return meta.getContentAttribute();
        }
        return this.getWebResponse().getResponseHeaderValue("Refresh");
    }

    private void executeDeferredScriptsIfNeeded() {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return;
        }
        if (!this.getWebClient().getBrowserVersion().isIE()) {
            return;
        }
        List scripts = this.getDocumentHtmlElement().getHtmlElementsByTagName("script");
        Iterator i = scripts.iterator();
        while (i.hasNext()) {
            HtmlScript script = (HtmlScript)i.next();
            String defer = script.getDeferAttribute();
            if (defer == HtmlElement.ATTRIBUTE_NOT_DEFINED) continue;
            script.executeScriptIfNeeded(true);
        }
    }

    private DomNode getFirstParent(DomNode node, String nodeName) {
        for (DomNode parent = node.getParentDomNode(); parent != null; parent = parent.getParentDomNode()) {
            if (!parent.getNodeName().equals(nodeName)) continue;
            return parent;
        }
        return null;
    }

    public void deregisterFramesIfNeeded() {
        Iterator iter = this.getFrames().iterator();
        while (iter.hasNext()) {
            HtmlPage page;
            WebWindow window = (WebWindow)iter.next();
            this.getWebClient().deregisterWebWindow(window);
            if (!(window.getEnclosedPage() instanceof HtmlPage) || (page = (HtmlPage)window.getEnclosedPage()) == null) continue;
            page.deregisterFramesIfNeeded();
        }
    }

    public List getFrames() {
        ArrayList<WebWindow> list = new ArrayList<WebWindow>();
        WebWindow enclosingWindow = this.getEnclosingWindow();
        Iterator iter = this.getWebClient().getWebWindows().iterator();
        while (iter.hasNext()) {
            WebWindow window = (WebWindow)iter.next();
            if (enclosingWindow != window.getParentWindow() || enclosingWindow == window) continue;
            list.add(window);
        }
        return list;
    }

    public FrameWindow getFrameByName(String name) throws ElementNotFoundException {
        List frames = this.getFrames();
        Iterator iter = frames.iterator();
        while (iter.hasNext()) {
            FrameWindow frame = (FrameWindow)iter.next();
            if (!frame.getName().equals(name)) continue;
            return frame;
        }
        throw new ElementNotFoundException("frame or iframe", "name", name);
    }

    public HtmlElement pressAccessKey(char accessKey) throws IOException {
        HtmlElement element = this.getHtmlElementByAccessKey(accessKey);
        if (element != null) {
            element.focus();
            Page newPage = element instanceof HtmlAnchor ? ((HtmlAnchor)element).click() : (element instanceof HtmlArea ? ((HtmlArea)element).click() : (element instanceof HtmlButton ? ((HtmlButton)element).click() : (element instanceof HtmlInput ? ((HtmlInput)element).click() : (element instanceof HtmlLabel ? ((HtmlLabel)element).click() : (element instanceof HtmlLegend ? ((HtmlLegend)element).click() : (element instanceof HtmlTextArea ? ((HtmlTextArea)element).click() : this))))));
            if (newPage != this && this.getElementWithFocus() == element) {
                this.getElementWithFocus().blur();
            }
        }
        return this.getElementWithFocus();
    }

    public HtmlElement tabToNextElement() {
        int index;
        List elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.moveFocusToElement(null);
            return null;
        }
        HtmlElement elementWithFocus = this.getElementWithFocus();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? (HtmlElement)elements.get(0) : ((index = elements.indexOf(elementWithFocus)) == -1 ? (HtmlElement)elements.get(0) : (index == elements.size() - 1 ? (HtmlElement)elements.get(0) : (HtmlElement)elements.get(index + 1)));
        this.moveFocusToElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public HtmlElement tabToPreviousElement() {
        int index;
        List elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.moveFocusToElement(null);
            return null;
        }
        HtmlElement elementWithFocus = this.getElementWithFocus();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? (HtmlElement)elements.get(elements.size() - 1) : ((index = elements.indexOf(elementWithFocus)) == -1 ? (HtmlElement)elements.get(elements.size() - 1) : (index == 0 ? (HtmlElement)elements.get(elements.size() - 1) : (HtmlElement)elements.get(index - 1)));
        this.moveFocusToElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public HtmlElement getHtmlElementById(String id) throws ElementNotFoundException {
        List elements = (List)this.idMap_.get(id);
        if (elements != null) {
            return (HtmlElement)elements.get(0);
        }
        throw new ElementNotFoundException("*", "id", id);
    }

    public List getHtmlElementsByName(String name) {
        List list = (List)this.nameMap_.get(name);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.EMPTY_LIST;
    }

    public List getHtmlElementsByIdAndOrName(String idAndOrName) {
        List list1 = (List)this.idMap_.get(idAndOrName);
        List list2 = (List)this.nameMap_.get(idAndOrName);
        ArrayList list = new ArrayList();
        if (list1 != null) {
            list.addAll(list1);
        }
        if (list2 != null) {
            list.addAll(list2);
        }
        return Collections.unmodifiableList(list);
    }

    void addMappedElement(HtmlElement element) {
        this.addMappedElement(element, false);
    }

    void addMappedElement(HtmlElement element, boolean recurse) {
        if (this.isDescendant(element)) {
            this.addElement(this.idMap_, element, "id", recurse);
            this.addElement(this.nameMap_, element, "name", recurse);
        }
    }

    private boolean isDescendant(HtmlElement element) {
        for (DomNode parent = element; parent != null; parent = parent.getParentDomNode()) {
            if (parent != this) continue;
            return true;
        }
        return false;
    }

    private void addElement(Map map, HtmlElement element, String attribute, boolean recurse) {
        String value = element.getAttributeValue(attribute);
        if (!StringUtils.isEmpty((String)value)) {
            Vector<HtmlElement> elements = (Vector<HtmlElement>)map.get(value);
            if (elements == null) {
                elements = new Vector<HtmlElement>();
                elements.add(element);
                map.put(value, elements);
            } else if (!elements.contains(element)) {
                elements.add(element);
            }
        }
        if (recurse) {
            Iterator i = element.getChildElementsIterator();
            while (i.hasNext()) {
                HtmlElement child = (HtmlElement)i.next();
                this.addElement(map, child, attribute, true);
            }
        }
    }

    void removeMappedElement(HtmlElement element) {
        this.removeMappedElement(element, false, false);
    }

    void removeMappedElement(HtmlElement element, boolean recurse, boolean descendant) {
        if (descendant || this.isDescendant(element)) {
            this.removeElement(this.idMap_, element, "id", recurse);
            this.removeElement(this.nameMap_, element, "name", recurse);
        }
    }

    private void removeElement(Map map, HtmlElement element, String att, boolean recurse) {
        List elements;
        String value = element.getAttributeValue(att);
        if (!StringUtils.isEmpty((String)value) && (elements = (List)map.remove(value)) != null && elements.size() != 1) {
            elements.remove(element);
            map.put(value, elements);
        }
        if (recurse) {
            Iterator i = element.getChildElementsIterator();
            while (i.hasNext()) {
                HtmlElement child = (HtmlElement)i.next();
                this.removeElement(map, child, att, true);
            }
        }
    }

    void notifyNodeAdded(DomNode node) {
        if (node instanceof HtmlElement) {
            boolean insideNoScript = false;
            if (this.getWebClient().isJavaScriptEnabled()) {
                for (DomNode parent = node.getParentDomNode(); parent != null; parent = parent.getParentDomNode()) {
                    if (!(parent instanceof HtmlNoScript)) continue;
                    insideNoScript = true;
                    break;
                }
            }
            if (!insideNoScript) {
                this.addMappedElement((HtmlElement)node, true);
            }
        }
        node.onAddedToPage();
    }

    void notifyNodeRemoved(DomNode node) {
        if (node instanceof HtmlElement) {
            this.removeMappedElement((HtmlElement)node, true, true);
        }
    }

    void loadFrames() throws FailingHttpStatusCodeException {
        List<String> frameTags = Arrays.asList("frame", "iframe");
        List frames = this.getDocumentHtmlElement().getHtmlElementsByTagNames(frameTags);
        Iterator iter = frames.iterator();
        while (iter.hasNext()) {
            BaseFrame frame = (BaseFrame)iter.next();
            if (frame.getEnclosedPage().getWebResponse().getUrl() != WebClient.URL_ABOUT_BLANK) continue;
            frame.loadInnerPage();
        }
    }

    public String asXml() {
        return this.getDocumentHtmlElement().asXml();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HtmlPage(");
        buffer.append(this.getWebResponse().getUrl());
        buffer.append(")@");
        buffer.append(this.hashCode());
        return buffer.toString();
    }

    public boolean moveFocusToElement(HtmlElement newElement) {
        if (this.elementWithFocus_ == newElement) {
            return true;
        }
        if (newElement != null && newElement.getPage() != this) {
            throw new IllegalArgumentException("Can't move focus to an element from an other page");
        }
        if (this.elementWithFocus_ != null) {
            this.elementWithFocus_.fireEvent("blur");
        }
        this.elementWithFocus_ = newElement;
        if (newElement != null) {
            newElement.fireEvent("focus");
        }
        return this == this.getEnclosingWindow().getEnclosedPage();
    }

    public HtmlElement getElementWithFocus() {
        return this.elementWithFocus_;
    }

    protected List getMetaTags(String httpEquiv) {
        String nameLC = httpEquiv.toLowerCase();
        List tags = this.getDocumentHtmlElement().getHtmlElementsByTagNames(Collections.singletonList("meta"));
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            HtmlMeta element = (HtmlMeta)iter.next();
            if (nameLC.equals(element.getHttpEquivAttribute().toLowerCase())) continue;
            iter.remove();
        }
        return tags;
    }

    void setCheckedRadioButton(HtmlRadioButtonInput radioButtonInput) {
        try {
            List pageInputs = this.getByXPath("//input[lower-case(@type)='radio' and @name='" + radioButtonInput.getNameAttribute() + "']");
            List formInputs = this.getByXPath("//form//input[lower-case(@type)='radio' and @name='" + radioButtonInput.getNameAttribute() + "']");
            pageInputs.removeAll(formInputs);
            Iterator iterator = pageInputs.iterator();
            while (iterator.hasNext()) {
                HtmlRadioButtonInput input = (HtmlRadioButtonInput)iterator.next();
                if (input == radioButtonInput) {
                    input.setAttributeValue("checked", "checked");
                    continue;
                }
                input.removeAttribute("checked");
            }
        }
        catch (JaxenException e) {
            this.getLog().error((Object)e);
        }
    }

    protected Object clone() {
        try {
            HtmlPage result = (HtmlPage)super.clone();
            result.documentElement_ = null;
            result.elementWithFocus_ = null;
            result.idMap_ = new HashMap();
            result.nameMap_ = new HashMap();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported");
        }
    }

    public DomNode cloneNode(boolean deep) {
        HtmlPage result = (HtmlPage)super.cloneDomNode(deep);
        if (deep) {
            Iterator it = result.getAllHtmlChildElements();
            while (it.hasNext()) {
                HtmlElement child = (HtmlElement)it.next();
                this.removeMappedElement(child);
                result.addMappedElement(child);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        Assert.notNull("listener", listener);
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ == null) {
                this.attributeListeners_ = new ArrayList();
            }
            if (!this.attributeListeners_.contains(listener)) {
                this.attributeListeners_.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        Assert.notNull("listener", listener);
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ != null) {
                this.attributeListeners_.remove(listener);
            }
        }
    }

    void fireHtmlAttributeAdded(HtmlAttributeChangeEvent event) {
        List listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                HtmlAttributeChangeListener listener = (HtmlAttributeChangeListener)iterator.next();
                listener.attributeAdded(event);
            }
        }
    }

    void fireHtmlAttributeReplaced(HtmlAttributeChangeEvent event) {
        List listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                HtmlAttributeChangeListener listener = (HtmlAttributeChangeListener)iterator.next();
                listener.attributeReplaced(event);
            }
        }
    }

    void fireHtmlAttributeRemoved(HtmlAttributeChangeEvent event) {
        List listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                HtmlAttributeChangeListener listener = (HtmlAttributeChangeListener)iterator.next();
                listener.attributeRemoved(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List safeGetAttributeListeners() {
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ != null) {
                return new ArrayList(this.attributeListeners_);
            }
            return null;
        }
    }

    public boolean isOnbeforeunloadAccepted() {
        return this.executeEventHandlersIfNeeded("beforeunload");
    }
}

