/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class HtmlLabel
extends ClickableElement {
    private static final long serialVersionUID = -3007176633287091652L;
    public static final String TAG_NAME = "label";

    public HtmlLabel(HtmlPage page, Map attributes) {
        this(null, TAG_NAME, page, attributes);
    }

    HtmlLabel(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public final String getForAttribute() {
        return this.getAttributeValue("for");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public void blur() {
        ClickableElement element = this.getReferencedElement();
        if (element != null) {
            element.blur();
        }
    }

    public void focus() {
        ClickableElement element = this.getReferencedElement();
        if (element != null) {
            element.focus();
        }
    }

    public ClickableElement getReferencedElement() {
        block5: {
            String elementId = this.getForAttribute();
            if (!ATTRIBUTE_NOT_DEFINED.equals(elementId)) {
                try {
                    HtmlElement element = this.getHtmlElementById(elementId);
                    if (element instanceof ClickableElement) {
                        return (ClickableElement)element;
                    }
                    break block5;
                }
                catch (ElementNotFoundException e) {
                    return null;
                }
            }
            Iterator childIterator = this.getChildIterator();
            while (childIterator.hasNext()) {
                DomNode element = (DomNode)childIterator.next();
                if (!(element instanceof HtmlInput)) continue;
                return (HtmlInput)element;
            }
        }
        return null;
    }

    public Page click() throws IOException {
        Page page = super.click();
        ClickableElement element = this.getReferencedElement();
        Page response = element != null ? element.click() : page;
        return response;
    }
}

