/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.FocusableElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import java.io.IOException;
import java.util.Map;

public abstract class HtmlInput
extends FocusableElement
implements DisabledElement,
SubmittableElement {
    public static final String TAG_NAME = "input";
    private String defaultValue_ = this.getValueAttribute();

    public HtmlInput(HtmlPage page, Map attributes) {
        this(null, TAG_NAME, page, attributes);
    }

    public HtmlInput(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public Page setValueAttribute(String newValue) {
        Assert.notNull("newValue", newValue);
        this.setAttributeValue("value", newValue);
        return HtmlInput.executeOnChangeHandlerIfAppropriate(this);
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        return new KeyValuePair[]{new KeyValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public String asText() {
        return this.getValueAttribute();
    }

    public final String getTypeAttribute() {
        return this.getAttributeValue("type");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getValueAttribute() {
        return this.getAttributeValue("value");
    }

    public final String getCheckedAttribute() {
        return this.getAttributeValue("checked");
    }

    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final boolean isDisabled() {
        return this.isAttributeDefined("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttributeValue("readonly");
    }

    public final String getSizeAttribute() {
        return this.getAttributeValue("size");
    }

    public final String getMaxLengthAttribute() {
        return this.getAttributeValue("maxlength");
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final String getAltAttribute() {
        return this.getAttributeValue("alt");
    }

    public final String getUseMapAttribute() {
        return this.getAttributeValue("usemap");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttributeValue("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeValue("onchange");
    }

    public final String getAcceptAttribute() {
        return this.getAttributeValue("accept");
    }

    public final String getAlignAttribute() {
        return this.getAttributeValue("align");
    }

    public void reset() {
        this.setValueAttribute(this.defaultValue_);
    }

    public void setDefaultValue(String defaultValue) {
        boolean modifyValue = this.getPage().getWebClient().getBrowserVersion().isNetscape();
        this.setDefaultValue(defaultValue, modifyValue);
    }

    protected void setDefaultValue(String defaultValue, boolean modifyValue) {
        this.defaultValue_ = defaultValue;
        if (modifyValue) {
            this.setValueAttribute(defaultValue);
        }
    }

    public String getDefaultValue() {
        return this.defaultValue_;
    }

    public void setDefaultChecked(boolean defaultChecked) {
    }

    public boolean isDefaultChecked() {
        return false;
    }

    public Page setChecked(boolean isChecked) {
        return this.getPage();
    }

    public boolean isChecked() {
        return this.isAttributeDefined("checked");
    }

    public Page click(int x, int y) throws IOException, ElementNotFoundException {
        return this.click();
    }

    static Page executeOnChangeHandlerIfAppropriate(HtmlElement htmlElement) {
        HtmlPage page = htmlElement.getPage();
        JavaScriptEngine engine = htmlElement.getPage().getWebClient().getJavaScriptEngine();
        if (engine.isScriptRunning()) {
            return page;
        }
        ScriptResult scriptResult = htmlElement.fireEvent("change");
        if (page.getWebClient().getWebWindows().contains(page.getEnclosingWindow())) {
            return page.getEnclosingWindow().getEnclosedPage();
        }
        if (scriptResult != null) {
            return scriptResult.getNewPage();
        }
        return page;
    }
}

