/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class HtmlImage
extends ClickableElement {
    private static final long serialVersionUID = -2304247017681577696L;
    public static final String TAG_NAME = "img";
    private int lastClickX_;
    private int lastClickY_;

    public HtmlImage(HtmlPage page, Map attributes) {
        this(null, TAG_NAME, page, attributes);
    }

    HtmlImage(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final String getAltAttribute() {
        return this.getAttributeValue("alt");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getLongDescAttribute() {
        return this.getAttributeValue("longdesc");
    }

    public final String getHeightAttribute() {
        return this.getAttributeValue("height");
    }

    public final String getWidthAttribute() {
        return this.getAttributeValue("width");
    }

    public final String getUseMapAttribute() {
        return this.getAttributeValue("usemap");
    }

    public final String getIsmapAttribute() {
        return this.getAttributeValue("ismap");
    }

    public final String getAlignAttribute() {
        return this.getAttributeValue("align");
    }

    public final String getBorderAttribute() {
        return this.getAttributeValue("border");
    }

    public final String getHspaceAttribute() {
        return this.getAttributeValue("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttributeValue("vspace");
    }

    public Page click(int x, int y) throws IOException {
        this.lastClickX_ = x;
        this.lastClickY_ = y;
        return super.click();
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        if (this.getUseMapAttribute() != ATTRIBUTE_NOT_DEFINED) {
            String mapName = this.getUseMapAttribute().substring(1);
            HtmlElement doc = this.getPage().getDocumentHtmlElement();
            HtmlMap map = (HtmlMap)doc.getOneHtmlElementByAttribute("map", "name", mapName);
            Iterator it = map.getChildElementsIterator();
            while (it.hasNext()) {
                HtmlArea area;
                HtmlElement element = (HtmlElement)it.next();
                if (!(element instanceof HtmlArea) || !(area = (HtmlArea)element).containsPoint(this.lastClickX_, this.lastClickY_)) continue;
                return area.doClickAction(defaultPage);
            }
            return super.doClickAction(defaultPage);
        }
        HtmlAnchor anchor = (HtmlAnchor)this.getEnclosingElement("a");
        if (anchor == null) {
            return super.doClickAction(defaultPage);
        }
        if (this.getIsmapAttribute() != ATTRIBUTE_NOT_DEFINED) {
            String suffix = "?" + this.lastClickX_ + "," + this.lastClickY_;
            return anchor.doClickAction(defaultPage, suffix);
        }
        return anchor.doClickAction(defaultPage);
    }
}

