/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttr;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;

public abstract class HtmlElement
extends DomElement {
    public static final String ATTRIBUTE_NOT_DEFINED = new String("");
    public static final String ATTRIBUTE_VALUE_EMPTY = new String("");
    public static final Short TAB_INDEX_OUT_OF_BOUNDS = new Short(Short.MIN_VALUE);
    private Map attributes_;
    private Map namespaces_ = new HashMap();
    private List attributeListeners_;

    protected HtmlElement(String namespaceURI, String qualifiedName, HtmlPage htmlPage, Map attributes) {
        super(namespaceURI, qualifiedName, htmlPage);
        if (attributes != null) {
            this.attributes_ = this.upgradeAttributes(htmlPage, attributes);
            Iterator entryIterator = this.attributes_.values().iterator();
            while (entryIterator.hasNext()) {
                HtmlAttr entry = (HtmlAttr)entryIterator.next();
                entry.setParentNode(this);
                String attrNamespaceURI = entry.getNamespaceURI();
                if (attrNamespaceURI == null) continue;
                this.namespaces_.put(attrNamespaceURI, entry.getPrefix());
            }
        } else {
            this.attributes_ = Collections.EMPTY_MAP;
        }
    }

    private Map upgradeAttributes(HtmlPage htmlPage, Map attributes) {
        Object firstValue;
        Map upgradedAttributes = attributes;
        if (attributes != null && attributes.size() > 0 && (firstValue = attributes.values().iterator().next()) instanceof String) {
            upgradedAttributes = HtmlElement.createAttributeMap(attributes.size());
            Iterator entryIterator = attributes.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                HtmlElement.addAttributeToMap(htmlPage, upgradedAttributes, null, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        return upgradedAttributes;
    }

    public DomNode cloneNode(boolean deep) {
        return this.cloneDomNode(deep);
    }

    public DomNode cloneDomNode(boolean deep) {
        HtmlElement newNode = (HtmlElement)super.cloneDomNode(deep);
        Set keySet = this.attributes_.keySet();
        newNode.attributes_ = HtmlElement.createAttributeMap(keySet.size());
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            HtmlAttr attr = (HtmlAttr)this.attributes_.get(key);
            newNode.setAttributeValue(attr.getNamespaceURI(), attr.getQualifiedName(), attr.getNodeValue());
        }
        return newNode;
    }

    public final String getAttribute(String attributeName) {
        return this.getAttributeValue(attributeName);
    }

    private String getQualifiedName(String namespaceURI, String localName) {
        String prefix;
        String qualifiedName = namespaceURI != null ? ((prefix = (String)this.namespaces_.get(namespaceURI)) != null ? prefix + ':' + localName : localName) : localName;
        return qualifiedName;
    }

    public final String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeValue(this.getQualifiedName(namespaceURI, localName));
    }

    public boolean hasAttributes() {
        return this.attributes_.size() > 0;
    }

    public final boolean hasAttribute(String attributeName) {
        return this.attributes_.get(attributeName) != null;
    }

    public final boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.attributes_.get(this.getQualifiedName(namespaceURI, localName)) != null;
    }

    public final String getAttributeValue(String attributeName) {
        HtmlAttr attr = (HtmlAttr)this.attributes_.get(attributeName.toLowerCase());
        if (attr != null) {
            return attr.getNodeValue();
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    public final void setAttribute(String attributeName, String attributeValue) {
        this.setAttributeValue(null, attributeName, attributeValue);
    }

    public final void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        this.setAttributeValue(namespaceURI, qualifiedName, attributeValue);
    }

    public final void setAttributeValue(String attributeName, String attributeValue) {
        this.setAttributeValue(null, attributeName, attributeValue);
    }

    public void setAttributeValue(String namespaceURI, String qualifiedName, String attributeValue) {
        String oldAttributeValue = this.getAttributeValue(qualifiedName);
        String value = attributeValue;
        if (this.attributes_ == Collections.EMPTY_MAP) {
            this.attributes_ = HtmlElement.createAttributeMap(1);
        }
        if (value.length() == 0) {
            value = ATTRIBUTE_VALUE_EMPTY;
        }
        this.getPage().removeMappedElement(this);
        HtmlAttr newAttr = HtmlElement.addAttributeToMap(this.getPage(), this.attributes_, namespaceURI, qualifiedName.toLowerCase(), value);
        if (namespaceURI != null) {
            this.namespaces_.put(namespaceURI, newAttr.getPrefix());
        }
        this.getPage().addMappedElement(this);
        HtmlAttributeChangeEvent event = oldAttributeValue == ATTRIBUTE_NOT_DEFINED ? new HtmlAttributeChangeEvent(this, qualifiedName, attributeValue) : new HtmlAttributeChangeEvent(this, qualifiedName, oldAttributeValue);
        if (oldAttributeValue == ATTRIBUTE_NOT_DEFINED) {
            this.fireHtmlAttributeAdded(event);
            this.getPage().fireHtmlAttributeAdded(event);
        } else {
            this.fireHtmlAttributeReplaced(event);
            this.getPage().fireHtmlAttributeReplaced(event);
        }
    }

    public final void removeAttribute(String attributeName) {
        String value = this.getAttributeValue(attributeName);
        this.getPage().removeMappedElement(this);
        this.attributes_.remove(attributeName.toLowerCase());
        this.getPage().addMappedElement(this);
        HtmlAttributeChangeEvent event = new HtmlAttributeChangeEvent(this, attributeName, value);
        this.fireHtmlAttributeRemoved(event);
        this.getPage().fireHtmlAttributeRemoved(event);
    }

    public final void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(this.getQualifiedName(namespaceURI, localName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeAdded(HtmlAttributeChangeEvent event) {
        DomNode parentNode;
        if (this.attributeListeners_ != null) {
            HtmlElement htmlElement = this;
            synchronized (htmlElement) {
                Iterator iterator = this.attributeListeners_.iterator();
                while (iterator.hasNext()) {
                    ((HtmlAttributeChangeListener)iterator.next()).attributeAdded(event);
                }
            }
        }
        if ((parentNode = this.getParentDomNode()) instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeAdded(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeReplaced(HtmlAttributeChangeEvent event) {
        DomNode parentNode;
        if (this.attributeListeners_ != null) {
            HtmlElement htmlElement = this;
            synchronized (htmlElement) {
                Iterator iterator = this.attributeListeners_.iterator();
                while (iterator.hasNext()) {
                    ((HtmlAttributeChangeListener)iterator.next()).attributeReplaced(event);
                }
            }
        }
        if ((parentNode = this.getParentDomNode()) instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeReplaced(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeRemoved(HtmlAttributeChangeEvent event) {
        DomNode parentNode;
        if (this.attributeListeners_ != null) {
            HtmlElement htmlElement = this;
            synchronized (htmlElement) {
                Iterator iterator = this.attributeListeners_.iterator();
                while (iterator.hasNext()) {
                    ((HtmlAttributeChangeListener)iterator.next()).attributeRemoved(event);
                }
            }
        }
        if ((parentNode = this.getParentDomNode()) instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeRemoved(event);
        }
    }

    public boolean isAttributeDefined(String attributeName) {
        return this.attributes_.get(attributeName.toLowerCase()) != null;
    }

    public Iterator getAttributeEntriesIterator() {
        return this.attributes_.values().iterator();
    }

    public String getTagName() {
        if (this.getNamespaceURI() == null) {
            return this.getLocalName().toLowerCase();
        }
        return this.getQualifiedName();
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        return this.getTagName();
    }

    public final String getId() {
        return this.getAttributeValue("id");
    }

    public final void setId(String newId) {
        this.setAttributeValue("id", newId);
    }

    public Short getTabIndex() {
        String index = this.getAttributeValue("tabindex");
        if (index == null || index.length() == 0) {
            return null;
        }
        try {
            long l = Long.parseLong(index);
            if (l >= 0L && l <= 32767L) {
                return new Short(new Long(l).shortValue());
            }
            return TAB_INDEX_OUT_OF_BOUNDS;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public HtmlElement getEnclosingElement(String tagName) {
        String tagNameLC = tagName.toLowerCase();
        for (DomNode currentNode = this.getParentDomNode(); currentNode != null; currentNode = currentNode.getParentDomNode()) {
            if (!(currentNode instanceof HtmlElement) || !currentNode.getNodeName().equals(tagNameLC)) continue;
            return (HtmlElement)currentNode;
        }
        return null;
    }

    public HtmlForm getEnclosingForm() {
        return (HtmlForm)this.getEnclosingElement("form");
    }

    public HtmlForm getEnclosingFormOrDie() throws IllegalStateException {
        HtmlForm form = this.getEnclosingForm();
        if (form == null) {
            throw new IllegalStateException("Element is not contained within a form: " + this);
        }
        return form;
    }

    public void keyDown(int keyCode) {
        this.keyDown(keyCode, false, false, false);
    }

    public void keyDown(int keyCode, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return;
        }
        this.fireEvent(new Event(this, "keydown", keyCode, shiftKey, ctrlKey, altKey));
    }

    public void type(String text) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            this.type(text.charAt(i));
        }
    }

    public void type(String text, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            this.type(text.charAt(i), shiftKey, ctrlKey, altKey);
        }
    }

    public Page type(char c) throws IOException {
        return this.type(c, false, false, false);
    }

    public Page type(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        this.fireEvent(new Event(this, "keydown", c, shiftKey, ctrlKey, altKey));
        this.fireEvent(new Event(this, "keypress", c, shiftKey, ctrlKey, altKey));
        this.fireEvent(new Event(this, "keyup", c, shiftKey, ctrlKey, altKey));
        HtmlForm form = this.getEnclosingForm();
        if (form != null && c == '\n' && this.isSubmittableByEnter()) {
            return form.submit((SubmittableElement)((Object)this));
        }
        return this.getPage();
    }

    protected boolean isSubmittableByEnter() {
        return false;
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        boolean hasChildren = this.getFirstDomChild() != null;
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        if (!hasChildren && !this.isEmptyXmlTagExpanded()) {
            printWriter.println("/>");
        } else {
            printWriter.println(">");
            this.printChildrenAsXml(indent, printWriter);
            printWriter.println(indent + "</" + this.getTagName() + ">");
        }
    }

    protected boolean isEmptyXmlTagExpanded() {
        return false;
    }

    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        Iterator it = this.attributes_.keySet().iterator();
        while (it.hasNext()) {
            printWriter.print(" ");
            String name = (String)it.next();
            printWriter.print(name);
            printWriter.print("=\"");
            printWriter.print(StringEscapeUtils.escapeXml((String)((HtmlAttr)this.attributes_.get(name)).getNodeValue()));
            printWriter.print("\"");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ClassUtils.getShortClassName(this.getClass()));
        buffer.append("[<");
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        this.printOpeningTagContentAsXml(printWriter);
        buffer.append(writer.toString());
        buffer.append(">]");
        return buffer.toString();
    }

    protected final void notImplemented() {
        throw new RuntimeException("Not implemented yet");
    }

    protected final void assertNotEmpty(String description, String string) throws IllegalArgumentException {
        if (string.length() == 0) {
            throw new IllegalArgumentException("String may not be empty: " + description);
        }
    }

    public final HtmlElement getOneHtmlElementByAttribute(String elementName, String attributeName, String attributeValue) throws ElementNotFoundException {
        Assert.notNull("elementName", elementName);
        Assert.notNull("attributeName", attributeName);
        Assert.notNull("attributeValue", attributeValue);
        List list = this.getHtmlElementsByAttribute(elementName, attributeName, attributeValue);
        int listSize = list.size();
        if (listSize == 0) {
            throw new ElementNotFoundException(elementName, attributeName, attributeValue);
        }
        return (HtmlElement)list.get(0);
    }

    public HtmlElement getHtmlElementById(String id) throws ElementNotFoundException {
        return this.getPage().getHtmlElementById(id);
    }

    public boolean hasHtmlElementWithId(String id) {
        try {
            this.getHtmlElementById(id);
            return true;
        }
        catch (ElementNotFoundException e) {
            return false;
        }
    }

    public final List getHtmlElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        DomNode.DescendantElementsIterator iterator = new DomNode.DescendantElementsIterator();
        String lowerCaseTagName = elementName.toLowerCase();
        while (iterator.hasNext()) {
            String attValue;
            HtmlElement next = iterator.nextElement();
            if (!next.getTagName().equals(lowerCaseTagName) || (attValue = next.getAttributeValue(attributeName)) == null || !attValue.equals(attributeValue)) continue;
            list.add(next);
        }
        return list;
    }

    public final List getHtmlElementsByTagNames(List acceptableTagNames) {
        ArrayList list = new ArrayList();
        Iterator iterator = acceptableTagNames.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next().toString().toLowerCase();
            list.addAll(this.getHtmlElementsByTagName(next));
        }
        return list;
    }

    public final List getHtmlElementsByTagName(String tagName) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        DomNode.DescendantElementsIterator iterator = new DomNode.DescendantElementsIterator();
        String lowerCaseTagName = tagName.toLowerCase();
        while (iterator.hasNext()) {
            HtmlElement next = iterator.nextElement();
            if (!lowerCaseTagName.equals(next.getTagName())) continue;
            list.add(next);
        }
        return list;
    }

    public final HtmlElement appendChildIfNoneExists(String tagName) {
        HtmlElement child;
        List children = this.getHtmlElementsByTagName(tagName);
        if (children.isEmpty()) {
            child = this.getPage().createHtmlElement(tagName);
            this.appendDomChild(child);
        } else {
            child = (HtmlElement)children.get(0);
        }
        return child;
    }

    public final void removeChild(String tagName, int i) {
        List children = this.getHtmlElementsByTagName(tagName);
        if (i >= 0 && i < children.size()) {
            HtmlElement child = (HtmlElement)children.get(i);
            child.remove();
        }
    }

    public final Iterator getChildElementsIterator() {
        return new ChildElementsIterator();
    }

    static Map createAttributeMap(int attributeCount) {
        return ListOrderedMap.decorate(new HashMap(attributeCount));
    }

    static HtmlAttr addAttributeToMap(HtmlPage page, Map attributeMap, String namespaceURI, String qualifiedName, String value) {
        HtmlAttr newAttr = new HtmlAttr(page, namespaceURI, qualifiedName, value);
        attributeMap.put(qualifiedName, newAttr);
        return newAttr;
    }

    public final Function getEventHandler(String eventName) {
        HTMLElement jsObj = (HTMLElement)this.getScriptObject();
        return jsObj.getEventHandler(eventName);
    }

    public final void setEventHandler(String eventName, Function eventHandler) {
        HTMLElement jsObj = (HTMLElement)this.getScriptObject();
        jsObj.setEventHandler(eventName, eventHandler);
    }

    public final void setEventHandler(String eventName, String jsSnippet) {
        EventHandler function = new EventHandler(this, eventName, jsSnippet);
        this.setEventHandler(eventName, (Function)function);
        this.getLog().debug((Object)("Created event handler " + function.getFunctionName() + " for " + eventName + " on " + this));
    }

    public final void removeEventHandler(String eventName) {
        this.setEventHandler(eventName, (Function)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        Assert.notNull("listener", listener);
        HtmlElement htmlElement = this;
        synchronized (htmlElement) {
            if (this.attributeListeners_ == null) {
                this.attributeListeners_ = new ArrayList();
            }
            this.attributeListeners_.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        Assert.notNull("listener", listener);
        HtmlElement htmlElement = this;
        synchronized (htmlElement) {
            if (this.attributeListeners_ != null) {
                this.attributeListeners_.remove(listener);
            }
        }
    }

    public ScriptResult fireEvent(String eventType) {
        return this.fireEvent(new Event(this, eventType));
    }

    public ScriptResult fireEvent(final Event event) {
        if (!this.getPage().getWebClient().isJavaScriptEnabled()) {
            return null;
        }
        this.getLog().debug((Object)("Firing " + (Object)((Object)event)));
        final HTMLElement jsElt = (HTMLElement)this.getScriptObject();
        ContextAction action = new ContextAction(){

            public Object run(Context cx) {
                return jsElt.fireEvent(event);
            }
        };
        ScriptResult result = (ScriptResult)Context.call((ContextAction)action);
        boolean isIE = this.getPage().getWebClient().getBrowserVersion().isIE();
        if (!isIE && event.isPreventDefault() || isIE && ScriptResult.isFalse(result)) {
            this.preventDefault();
        }
        return result;
    }

    protected void preventDefault() {
    }

    public Page mouseOver() {
        return this.mouseOver(false, false, false, 0);
    }

    public Page mouseOver(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseover", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseMove() {
        return this.mouseMove(false, false, false, 0);
    }

    public Page mouseMove(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mousemove", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseOut() {
        return this.mouseOut(false, false, false, 0);
    }

    public Page mouseOut(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseout", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseDown() {
        return this.mouseDown(false, false, false, 0);
    }

    public Page mouseDown(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mousedown", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseUp() {
        return this.mouseUp(false, false, false, 0);
    }

    public Page mouseUp(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseup", shiftKey, ctrlKey, altKey, button);
    }

    private Page doMouseEvent(String eventType, boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        HtmlPage page = this.getPage();
        MouseEvent event = new MouseEvent((DomNode)this, eventType, shiftKey, ctrlKey, altKey, button);
        ScriptResult scriptResult = this.fireEvent(event);
        Page currentPage = scriptResult == null ? page : scriptResult.getNewPage();
        return currentPage;
    }

    public Page rightClick() {
        return this.rightClick(false, false, false);
    }

    public Page rightClick(boolean shiftKey, boolean ctrlKey, boolean altKey) {
        Page mouseDownPage = this.mouseDown(shiftKey, ctrlKey, altKey, 2);
        if (mouseDownPage != this.getPage()) {
            this.getLog().debug((Object)"rightClick() is incomplete, as mouseDown() loaded a different page.");
            return mouseDownPage;
        }
        Page mouseUpPage = this.mouseUp(shiftKey, ctrlKey, altKey, 2);
        if (mouseUpPage != this.getPage()) {
            this.getLog().debug((Object)"rightClick() is incomplete, as mouseUp() loaded a different page.");
            return mouseUpPage;
        }
        return this.doMouseEvent("contextmenu", shiftKey, ctrlKey, altKey, 2);
    }

    public void blur() {
        this.getPage().moveFocusToElement(null);
    }

    public void focus() {
        this.getPage().moveFocusToElement(this);
    }

    public static class MapEntryWrappingIterator
    implements Iterator {
        private final Iterator baseIter_;

        public MapEntryWrappingIterator(Iterator iterator, HtmlElement htmlElement) {
            this.baseIter_ = iterator;
        }

        public boolean hasNext() {
            return this.baseIter_.hasNext();
        }

        public Object next() {
            return ((Map.Entry)this.baseIter_.next()).getValue();
        }

        public void remove() {
            this.baseIter_.remove();
        }
    }

    protected class ChildElementsIterator
    implements Iterator {
        private HtmlElement nextElement_;

        public ChildElementsIterator() {
            if (HtmlElement.this.getFirstDomChild() != null) {
                if (HtmlElement.this.getFirstDomChild() instanceof HtmlElement) {
                    this.nextElement_ = (HtmlElement)HtmlElement.this.getFirstDomChild();
                } else {
                    this.setNextElement(HtmlElement.this.getFirstDomChild());
                }
            }
        }

        public boolean hasNext() {
            return this.nextElement_ != null;
        }

        public Object next() {
            return this.nextElement();
        }

        public void remove() {
            if (this.nextElement_ == null) {
                throw new IllegalStateException();
            }
            DomNode sibling = this.nextElement_.getPreviousDomSibling();
            if (sibling != null) {
                sibling.remove();
            }
        }

        public HtmlElement nextElement() {
            if (this.nextElement_ != null) {
                HtmlElement result = this.nextElement_;
                this.setNextElement(this.nextElement_);
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextElement(DomNode node) {
            DomNode next;
            for (next = node.getNextDomSibling(); next != null && !(next instanceof HtmlElement); next = next.getNextDomSibling()) {
            }
            this.nextElement_ = (HtmlElement)next;
        }
    }
}

