/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import java.io.PrintWriter;
import org.apache.commons.lang.StringEscapeUtils;

public class DomText
extends DomCharacterData {
    private static final long serialVersionUID = 6589779086230288951L;
    public static final String NODE_NAME = "#text";

    public DomText(Page page, String data) {
        super(page, data);
    }

    public DomText splitText(int offset) {
        return this.splitDomText(offset);
    }

    public DomText splitDomText(int offset) {
        if (offset < 0 || offset > this.getLength()) {
            throw new IllegalArgumentException("offset: " + offset + " data.length: " + this.getLength());
        }
        DomText newText = new DomText(this.getPage(), this.getData().substring(offset));
        this.setData(this.getData().substring(0, offset));
        if (this.getParentDomNode() != null) {
            newText.setParentNode(this.getParentDomNode());
            newText.setPreviousSibling(this);
            newText.setNextSibling(this.getNextDomSibling());
            this.setNextSibling(newText);
        }
        return newText;
    }

    public String asText() {
        String text = this.getData();
        if (!(this.getParentDomNode() instanceof HtmlTextArea)) {
            text = DomText.reduceWhitespace(text);
        }
        return text;
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return NODE_NAME;
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.print(indent);
        printWriter.println(StringEscapeUtils.escapeXml((String)this.getData()));
        this.printChildrenAsXml(indent, printWriter);
    }

    public String toString() {
        return this.asText();
    }

    protected boolean isTrimmedText() {
        return false;
    }
}

