/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.StyledElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public abstract class BaseFrame
extends StyledElement {
    private final WebWindow enclosedWindow_ = new FrameWindow(this);

    protected BaseFrame(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        try {
            this.getPage().getWebClient().pushClearFirstWindow();
            this.getPage().getWebClient().getPage(this.enclosedWindow_, new WebRequestSettings(WebClient.URL_ABOUT_BLANK));
            this.getPage().getWebClient().popFirstWindow();
        }
        catch (FailingHttpStatusCodeException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    void loadInnerPage() throws FailingHttpStatusCodeException {
        String source = this.getSrcAttribute();
        if (source.length() == 0) {
            source = "about:blank";
        } else {
            this.getPage().getWebClient().pushClearFirstWindow();
            this.loadInnerPageIfPossible(source);
            this.getPage().getWebClient().popFirstWindow();
        }
    }

    private void loadInnerPageIfPossible(String src) throws FailingHttpStatusCodeException {
        if (src.length() != 0) {
            URL url;
            try {
                url = this.getPage().getFullyQualifiedUrl(src);
            }
            catch (MalformedURLException e) {
                this.notifyIncorrectness("Invalid src attribute of " + this.getTagName() + ": url=[" + src + "]. Ignored.");
                return;
            }
            if (this.isAlreadyLoadedByAncestor(url)) {
                this.notifyIncorrectness("Recursive src attribute of " + this.getTagName() + ": url=[" + src + "]. Ignored.");
                return;
            }
            try {
                WebRequestSettings settings = new WebRequestSettings(url);
                settings.addAdditionalHeader("Referer", this.getPage().getWebResponse().getUrl().toExternalForm());
                this.getPage().getWebClient().getPage(this.enclosedWindow_, settings);
            }
            catch (IOException e) {
                this.getLog().error((Object)("IOException when getting content for " + this.getTagName() + ": url=[" + url.toExternalForm() + "]"), (Throwable)e);
            }
        }
    }

    private boolean isAlreadyLoadedByAncestor(URL url) {
        WebWindow window = this.getPage().getEnclosingWindow();
        while (window != null) {
            if (url.sameFile(window.getEnclosedPage().getWebResponse().getUrl())) {
                return true;
            }
            if (window == window.getParentWindow()) {
                window = null;
                continue;
            }
            window = window.getParentWindow();
        }
        return false;
    }

    public final String getLongDescAttribute() {
        return this.getAttributeValue("longdesc");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final void setNameAttribute(String name) {
        this.setAttributeValue("name", name);
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final String getFrameBorderAttribute() {
        return this.getAttributeValue("frameborder");
    }

    public final String getMarginWidthAttribute() {
        return this.getAttributeValue("marginwidth");
    }

    public final String getMarginHeightAttribute() {
        return this.getAttributeValue("marginheight");
    }

    public final String getNoResizeAttribute() {
        return this.getAttributeValue("noresize");
    }

    public final String getScrollingAttribute() {
        return this.getAttributeValue("scrolling");
    }

    public final String getOnLoadAttribute() {
        return this.getAttributeValue("onload");
    }

    public Page getEnclosedPage() {
        return this.getEnclosedWindow().getEnclosedPage();
    }

    public WebWindow getEnclosedWindow() {
        return this.enclosedWindow_;
    }

    public final void setSrcAttribute(String attribute) {
        this.setAttributeValue("src", attribute);
    }

    public final void setAttributeValue(String namespaceURI, String qualifiedName, String attributeValue) {
        if (qualifiedName.equals("src")) {
            attributeValue = attributeValue.trim();
        }
        super.setAttributeValue(namespaceURI, qualifiedName, attributeValue);
        if (qualifiedName.equals("src")) {
            this.loadInnerPageIfPossible(attributeValue);
        }
    }
}

