/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.lang.ClassUtils;

public class WebRequestSettings {
    private URL url_;
    private String proxyHost_;
    private int proxyPort_;
    private SubmitMethod submitMethod_ = SubmitMethod.GET;
    private FormEncodingType encodingType_ = FormEncodingType.URL_ENCODED;
    private Map additionalHeaders_ = new HashMap();
    private CredentialsProvider credentialsProvider_;
    private String charset_ = "ISO-8859-1";
    private String cookiePolicy_;
    private List requestParameters_ = Collections.EMPTY_LIST;
    private String requestBody_;

    public WebRequestSettings(URL target) {
        this.setURL(target);
    }

    public WebRequestSettings(WebRequestSettings originalRequest, URL target) {
        this(target);
        this.setProxyHost(originalRequest.getProxyHost());
        this.setProxyPort(originalRequest.getProxyPort());
    }

    public WebRequestSettings(URL target, SubmitMethod submitMethod) {
        this(target);
        this.setSubmitMethod(submitMethod);
    }

    public URL getURL() {
        return this.url_;
    }

    public void setURL(URL url) {
        this.url_ = url;
    }

    public String getProxyHost() {
        return this.proxyHost_;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost_ = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort_;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort_ = proxyPort;
    }

    public FormEncodingType getEncodingType() {
        return this.encodingType_;
    }

    public void setEncodingType(FormEncodingType encodingType) {
        this.encodingType_ = encodingType;
    }

    public List getRequestParameters() {
        return this.requestParameters_;
    }

    public void setRequestParameters(List requestParameters) throws RuntimeException {
        if (this.requestBody_ != null) {
            String msg = "Trying to set the request parameters, but the request body has already been specified;the two are mutually exclusive!";
            throw new RuntimeException("Trying to set the request parameters, but the request body has already been specified;the two are mutually exclusive!");
        }
        this.requestParameters_ = requestParameters;
    }

    public String getRequestBody() {
        return this.requestBody_;
    }

    public void setRequestBody(String requestBody) throws RuntimeException {
        if (this.requestParameters_ != null && this.requestParameters_.size() > 0) {
            String msg = "Trying to set the request body, but the request parameters have already been specified;the two are mutually exclusive!";
            throw new RuntimeException("Trying to set the request body, but the request parameters have already been specified;the two are mutually exclusive!");
        }
        if (this.submitMethod_ != SubmitMethod.POST) {
            String msg = "The request body may only be set for POST requests!";
            throw new RuntimeException("The request body may only be set for POST requests!");
        }
        this.requestBody_ = requestBody;
    }

    public SubmitMethod getSubmitMethod() {
        return this.submitMethod_;
    }

    public void setSubmitMethod(SubmitMethod submitMethod) {
        this.submitMethod_ = submitMethod;
    }

    public Map getAdditionalHeaders() {
        return this.additionalHeaders_;
    }

    public void setAdditionalHeaders(Map additionalHeaders) {
        this.additionalHeaders_ = additionalHeaders;
    }

    public void addAdditionalHeader(String name, String value) {
        this.additionalHeaders_.put(name, value);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider_;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider_ = credentialsProvider;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ClassUtils.getShortClassName(this.getClass()));
        buffer.append("[<");
        buffer.append("url=\"" + this.url_.toExternalForm() + "\"");
        buffer.append(", " + this.submitMethod_);
        buffer.append(", " + this.encodingType_);
        buffer.append(", " + this.requestParameters_);
        buffer.append(", " + this.additionalHeaders_);
        buffer.append(", " + this.credentialsProvider_);
        buffer.append(">]");
        return buffer.toString();
    }

    public String getCharset() {
        return this.charset_;
    }

    public void setCharset(String charset) {
        this.charset_ = charset;
    }

    public String getCookiePolicy() {
        return this.cookiePolicy_;
    }

    public void setCookiePolicy(String cookiePolicy) {
        this.cookiePolicy_ = cookiePolicy;
    }
}

