/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadManager {
    private static final Log LOG = LogFactory.getLog((Class)ThreadManager.class);
    private Map threadMap_ = Collections.synchronizedMap(new TreeMap());
    private int nextThreadID_ = 1;
    private static final int PRIORITY = Math.min(10, Thread.currentThread().getPriority() + 1);

    public int activeCount() {
        return this.threadMap_.size();
    }

    private synchronized int getNextThreadId() {
        return this.nextThreadID_++;
    }

    public int startThread(Runnable job, String label) {
        final int myThreadID = this.getNextThreadId();
        Thread newThread = new Thread(job, "HtmlUnit Managed Thread #" + myThreadID + ": " + label){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    super.run();
                }
                finally {
                    ThreadManager.this.threadMap_.remove(new Integer(myThreadID));
                }
            }
        };
        newThread.setPriority(PRIORITY);
        newThread.setDaemon(true);
        this.threadMap_.put(new Integer(myThreadID), newThread);
        newThread.start();
        return myThreadID;
    }

    public void stopThread(int threadID) {
        Thread thread = (Thread)this.threadMap_.get(new Integer(threadID));
        if (thread != null) {
            thread.interrupt();
        }
    }

    public boolean joinAll(long maxWaitMillis) {
        Thread t = this.getNextThread();
        while (t != null && maxWaitMillis > 0L) {
            long before = System.currentTimeMillis();
            try {
                LOG.debug((Object)("Trying to join: " + t));
                t.join(maxWaitMillis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread " + t + " interrupted.", e);
            }
            maxWaitMillis -= System.currentTimeMillis() - before;
            t = this.getNextThread();
        }
        return this.threadMap_.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getNextThread() {
        Thread thread;
        Map map = this.threadMap_;
        synchronized (map) {
            Iterator i = this.threadMap_.values().iterator();
            thread = i.hasNext() ? (Thread)i.next() : null;
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAll() {
        Map map = this.threadMap_;
        synchronized (map) {
            HashSet keys = new HashSet(this.threadMap_.keySet());
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                Integer id = (Integer)i.next();
                this.stopThread(id);
            }
        }
    }

    public String toString() {
        return "ThreadManager: " + this.threadMap_;
    }
}

