/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;

public abstract class COSNumber
extends COSBase {
    public static final COSInteger ZERO = new COSInteger(0);
    public static final COSInteger ONE = new COSInteger(1);
    private static final Map COMMON_NUMBERS = new HashMap();

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract int intValue();

    public abstract long longValue();

    public static COSNumber get(String number) throws IOException {
        COSNumber result = (COSNumber)COMMON_NUMBERS.get(number);
        if (result == null) {
            result = number.indexOf(46) >= 0 ? new COSFloat(number) : new COSInteger(number);
        }
        return result;
    }

    static {
        COMMON_NUMBERS.put("0", ZERO);
        COMMON_NUMBERS.put("1", ONE);
    }
}

