package com.blogspot.berndschiffer.zartschmelzend;

import org.apache.commons.collections.map.ListOrderedMap;

import com.blogspot.berndschiffer.zartschmelzend.Abschnitt;

public class Abschnitte {

  private ListOrderedMap abschnitteZuNamen = new ListOrderedMap();
  private String letzterWert;

  public static Abschnitte mitNamen(String abschnittsname) {
    return addAbschnitt(abschnittsname, new Abschnitte());
  }

  private static Abschnitte addAbschnitt(String abschnittsname,
      final Abschnitte abschnitte) {
    abschnitte.add(Abschnitt.mitNamen(abschnittsname));
    return abschnitte;
  }
  
  public Abschnitte undMitNamen(String abschnittsname) {
    return addAbschnitt(abschnittsname, this);
  }

  private void add(Abschnitt abschnitt) {
    abschnitteZuNamen.put(abschnitt.getName(), abschnitt);
  }

  public Abschnitt findeMitName(String abschnittsname) {
    return (Abschnitt) abschnitteZuNamen.get(abschnittsname);
  }

  public Abschnitte mitWert(String wert) {
    letzterWert = wert;
    return this;
  }

  private Abschnitt getLetzterAbschnitt() {
    return (Abschnitt) abschnitteZuNamen.get(abschnitteZuNamen.lastKey());
  }

  public Abschnitte anStelle(int stelle) {
    getLetzterAbschnitt().undMitWert(letzterWert).anStelle(stelle);
    return this;
  }

  @SuppressWarnings("unchecked")
  public Abschnitte findeAlleMitWert(String gesuchterWert) {
    final Abschnitte gefundeneAbschnitte = new Abschnitte();
    for (Object object : abschnitteZuNamen.valueList()) {
      Abschnitt abschnitt = (Abschnitt) object;
      if (abschnitt.hatWert(gesuchterWert))
        gefundeneAbschnitte.add(abschnitt);
    }
    return gefundeneAbschnitte;
  }

  public boolean beinhaltetAbschnittMitNamen(String abschnittsname) {
    return abschnitteZuNamen.containsKey(abschnittsname);
  }
}
