package com.blogspot.berndschiffer.fluessig;

import org.apache.commons.collections.map.ListOrderedMap;

public class Abschnitte {

  protected ListOrderedMap abschnitteZuNamen = new ListOrderedMap();

  public static AbschnitteWertZuStelleDescriptor<Abschnitte> mitNamen(String abschnittsname) {
    return mitName(new Abschnitte(), abschnittsname);
  }

  private static AbschnitteWertZuStelleDescriptor<Abschnitte> mitName(
      final Abschnitte abschnitte, String abschnittsname) {
    abschnitte.add(Abschnitt.mitNamen(abschnittsname));
    final WertZuStelleAddierer<Abschnitte> addierer = new WertZuStelleAddierer<Abschnitte>() {

      public Abschnitte addWertZuStelle(String wert, int stelle) {
        getLetzterAbschnitt().undMitWert(wert).anStelle(stelle);
        return abschnitte;
      }

      private Abschnitt getLetzterAbschnitt() {
        return (Abschnitt) abschnitte.abschnitteZuNamen
            .get(abschnitte.abschnitteZuNamen.lastKey());
      }
    };
    return new AbschnitteWertZuStelleDescriptor<Abschnitte>(abschnitte, addierer);
  }

  public AbschnitteWertZuStelleDescriptor<Abschnitte> undMitNamen(String abschnittsname) {
    return mitName(this, abschnittsname);
  }

  protected void add(Abschnitt abschnitt) {
    abschnitteZuNamen.put(abschnitt.getName(), abschnitt);
  }

  public Abschnitt findeMitName(String abschnittsname) {
    return (Abschnitt) abschnitteZuNamen.get(abschnittsname);
  }

  public boolean beinhaltetAbschnittMitNamen(String abschnittsname) {
    return abschnitteZuNamen.containsKey(abschnittsname);
  }

  public Abschnitte findeAlleMitWert(String gesuchterWert) {
    final Abschnitte gefundeneAbschnitte = new Abschnitte();
    for (Object object : abschnitteZuNamen.valueList()) {
      Abschnitt abschnitt = (Abschnitt) object;
      if (abschnitt.hatWert(gesuchterWert))
        gefundeneAbschnitte.add(abschnitt);
    }
    return gefundeneAbschnitte;
  }
}