package com.blogspot.berndschiffer.fluessig;

import java.util.HashMap;
import java.util.Map;

public class Abschnitt {

  private final Map<Integer, String> werteZuStellen = new HashMap<Integer, String>();
  private String name;

  public static Abschnitt mitNamen(String name) {
    Abschnitt abschnitt = new Abschnitt();
    abschnitt.name = name;
    return abschnitt;
  }

  public AbschnittWertZuStelleDescriptor<Abschnitt> mitWert(String wert) {
    final Abschnitt abschnitt = this;
    final WertZuStelleAddierer<Abschnitt> addierer = new WertZuStelleAddierer<Abschnitt>() {
      public Abschnitt addWertZuStelle(String wert, int stelle) {
        werteZuStellen.put(stelle, wert);
        return abschnitt;
      }
    };
    return new AbschnittWertZuStelleDescriptor<Abschnitt>(addierer, wert);
  }

  public AbschnittWertZuStelleDescriptor<Abschnitt> undMitWert(String wert) {
    return mitWert(wert);
  }

  public String findeWertAnStelle(int stelle) {
    return werteZuStellen.get(stelle);
  }

  public String getName() {
    return name;
  }

  public boolean hatWert(String wert) {
    return werteZuStellen.containsValue(wert);
  }
}