package com.blogspot.berndschiffer.fluessigererbauer;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;

import com.blogspot.berndschiffer.fluessigererbauer.Abschnitte;
import com.blogspot.berndschiffer.fluessigererbauer.ErzeugeAbschnitte;

public class AbschnitteTest {

  @Test
  public void findetEinenAbschnittAnhandDesNamens() throws Exception {
    final String abschnittsname = "name";
    Abschnitte abschnitte = ErzeugeAbschnitte.mitNamen(abschnittsname).ohneWerte().jetzt();
    final String gefundenerName = abschnitte.findeMitName(abschnittsname)
        .getName();
    assertThat(abschnittsname, is(gefundenerName));
  }

  @Test
  public void findetMehrereAbschnitteAnhandDesNamens() throws Exception {
    final String gesuchterWert = "wert";
    final String abschnittsname = "abschnitt";
    final String wiederAndererAbschnittsname = "wieder anderer abschnitt";
    Abschnitte abschnitte = ErzeugeAbschnitte.mitNamen(abschnittsname).mitWert(
        gesuchterWert).anStelle(1).undMitNamen("anderer abschnitt").mitWert(
        "anderer wert").anStelle(2).undMitNamen(wiederAndererAbschnittsname)
        .mitWert(gesuchterWert).anStelle(3).jetzt();
    Abschnitte gefundeneAbschnitte = abschnitte.findeAlleMitWert(gesuchterWert);
    assertThat(gefundeneAbschnitte, beinhaltenAbschnittMitNamen(abschnittsname));
    assertThat(gefundeneAbschnitte,
        beinhaltenAbschnittMitNamen(wiederAndererAbschnittsname));
  }

  private Matcher<Abschnitte> beinhaltenAbschnittMitNamen(
      final String abschnittsname) {
    return new TypeSafeMatcher<Abschnitte>() {

      @Override
      public boolean matchesSafely(Abschnitte abschnitte) {
        return abschnitte.beinhaltetAbschnittMitNamen(abschnittsname);
      }

      public void describeTo(Description description) {
        description.appendText("beeinhaltet Abschnitt mit Namen <"
            + abschnittsname + ">");
      }
    };
  }
}
