package com.blogspot.berndschiffer.fest;

import static org.hamcrest.Matchers.hasKey;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import java.util.HashMap;
import java.util.Map;

import org.junit.Test;

public class AbschnittUtilTest {

  @Test
  public void findetEinenAbschnittAnhandDesNamens() throws Exception {
    final String abschnittsname = "name";
    Abschnitt abschnitt = new Abschnitt(abschnittsname);
    HashMap<String, Abschnitt> abschnitte = new HashMap<String, Abschnitt>();
    abschnitte.put(abschnittsname, abschnitt);
    final String gefundenerName = AbschnittUtil.findeMitName(abschnitte,
        abschnittsname).getName();
    assertThat(abschnittsname, is(gefundenerName));
  }

  @Test
  public void findetMehrereAbschnitteAnhandDesNamens() throws Exception {
    final String gesuchterWert = "wert";
    final String abschnittsname = "abschnitt";
    final String wiederAndererAbschnittsname = "wieder anderer abschnitt";
    Map<String, Abschnitt> abschnitte = new HashMap<String, Abschnitt>();

    Abschnitt abschnitt = new Abschnitt(abschnittsname);
    abschnitt.add(1, gesuchterWert);
    abschnitte.put(abschnittsname, abschnitt);

    final String andererAbschnittsname = "anderer abschnitt";
    Abschnitt andererAbschnitt = new Abschnitt(andererAbschnittsname);
    andererAbschnitt.add(2, "anderer wert");
    abschnitte.put(andererAbschnittsname, andererAbschnitt);

    Abschnitt wiederAndererAbschnitt = new Abschnitt(
        wiederAndererAbschnittsname);
    wiederAndererAbschnitt.add(3, gesuchterWert);
    abschnitte.put(wiederAndererAbschnittsname, wiederAndererAbschnitt);

    Map<String, Abschnitt> gefundeneAbschnitte = AbschnittUtil
        .findeAlleMitWert(abschnitte, gesuchterWert);
    assertThat(gefundeneAbschnitte, hasKey(abschnittsname));
    assertThat(gefundeneAbschnitte, hasKey(wiederAndererAbschnittsname));
  }
}
