package de.schoeso.application.web.libraryweb;

import java.util.Collection;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import de.schoeso.application.web.library.entity.Book;
import de.schoeso.application.web.library.entity.LibraryCatalog;
import de.schoeso.application.web.library.entity.LibraryItem;
import de.schoeso.application.web.library.entity.Magazine;
import de.schoeso.application.web.library.facade.LibraryRemote;

/**
 * BackingBean fr die Verbindung der Suchseite in JSF mit den EJBs
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */

public final class LibraryBackingBean extends Object {
	// Attribute fr die Eingabe an der Oberflche
	private LibraryCatalog searchcatalog = null;
	private String searchtitlepart = "";

	// Die ID der Auswahl
	private String selectedItemGUIID = null;	
	// Der gewhlte Eintrag, der automatisch gendert wird
	private LibraryItem selectedItem = null;
		
	InitialContext ic;
	// @EJB  // Injection in JSF funktioniert derzeit nicht - vergl http://jira.jboss.com/jira/browse/JBPAPP-192
	LibraryRemote facade;
	
	public LibraryBackingBean() {
		try {
			ic = new InitialContext();
		} catch (NamingException e) {
			System.err.println("Error obtaining Initial Context: " + e.getMessage());
			ic = null;
		}

		if (ic != null && facade==null) { // Injection failed
			try {
				facade = (LibraryRemote) ic.lookup("library/LibraryBean/remote"); 
			} catch (Exception e) {
				System.err.println("Error obtaining Facade: " + e.getMessage());
			}
		}
	}
	// ==== Initialisierung
	/** gibt die Kataloge der Bibliothek asl SelectItem zurck fr Select Komponenten der GUI zurck*/
	public SelectItem[] getCatalogSelectItems() {
		SelectItem[] catalogs = new SelectItem[getAllCatalogs().size()];
		int i = 0;
		for (LibraryCatalog item : getAllCatalogs()) {
			catalogs[i] = new SelectItem(item);
			i++;
		}
    return catalogs;
	}
	
	public Collection<LibraryCatalog> getAllCatalogs() {
		return facade.getAllCatalogs();
	}
	// ======== Funktionen
	/** Wird zur Navigation und zum Setzen der Suchergebnisse aufgerufen */
	public String search() {
		setSelectedItemID(null);
		setSelectedItem(null);
		Collection<LibraryItem> hits = facade.searchItems(getSearchcatalog(), getSearchtitlepart());
		if (hits != null && hits.size() > 0)
		  return "detail";
		else {
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Keine Treffer gefunden"));
			return "search";
		}
	}
  // ======== Eingaben der Suchseite ====
	public LibraryCatalog getSearchcatalog() {
		return searchcatalog;
	}
	public void setSearchcatalog(LibraryCatalog searchcatalog) {
		this.searchcatalog = searchcatalog;
	}
	public String getSearchtitlepart() {
		return searchtitlepart;
	}
	public void setSearchtitlepart(String searchtitlepart) {
		this.searchtitlepart = searchtitlepart;
	}
  // ======== Verwaltung der Treffer ====
	public SelectItem[] getHitsSelectItems() {
		SelectItem[] items = new SelectItem[facade.getLastSearchItems().size()];
		int i = 0;
		for (LibraryItem item : facade.getLastSearchItems()) {
			items[i] = new SelectItem(item);
			i++;
		}
    return items;
	}

	public String getSelectedItemID() {
		return selectedItemGUIID;
	}
	public void setSelectedItemID(String selectedItem) {
		this.selectedItemGUIID = selectedItem;
	}
	private LibraryItem getSelectedItem() {
		return selectedItem;
	}
	private void setSelectedItem(LibraryItem selectedItem){
		this.selectedItem = selectedItem;
	}
//	// action="#{libraryBackingBean.changeItem}" 
	/** Es werden erst alle Werte zurckgeschrieben! Darum darf erst an dieser Stelle das aktuelle Objekt gesetzt werden */
	public String changeItem() {
    // hier sind alle nderungen erfolgt, da die Werte von JSF in das Objekt bertragen wurden
		facade.saveItem(getSelectedItem());
		for (LibraryItem item : facade.getLastSearchItems()) {
			if (item.getTitle().equalsIgnoreCase(selectedItemGUIID)) {
				setSelectedItem(item);
				System.out.println("Action 1" + getSelectedItem() + " Version " + item.getVersion());	
			}
		}
		return null;
	}
	
	public boolean isBook() {
		return (getSelectedItem() != null) && (getSelectedItem() instanceof Book);
	}
	public boolean isMagazine() {
		return (getSelectedItem() != null) && (getSelectedItem() instanceof Magazine);
	}
  // ======== Eingaben bei der Anzeige und nderung der Treffer ====
	public LibraryCatalog getCatalog() {
		if (getSelectedItem() == null) return null;
		return getSelectedItem().getCatalog();
	}
	public void setCatalog(LibraryCatalog catalog) {
		getSelectedItem().setCatalog(catalog);
	}
	public String getTitle() {
		if (getSelectedItem() == null) return null;
		return getSelectedItem().getTitle();
	}
	public void setTitle(String title) {
		getSelectedItem().setTitle(title);
	}
	public void setAuthor(String author) {
System.out.println("Setze Au");		
		if (getSelectedItem() != null && getSelectedItem() instanceof Book) {
			Book b = ((Book)getSelectedItem());
System.out.println("author " + author);			
			b.setAuthor(author);
		}
	}
	public String getAuthor() {
		if (getSelectedItem() == null) return null;
		if (getSelectedItem() instanceof Book) {
			return ((Book)getSelectedItem()).getAuthor();			
		}
		return null;
	}
	public void setIsbn(String isbn) {
		if (getSelectedItem() != null && getSelectedItem() instanceof Book) {
			((Book)getSelectedItem()).setIsbn(isbn);			
		}
	}
	public String getIsbn() {
		if (getSelectedItem() == null) return null;
		if (getSelectedItem() instanceof Book) {
			return ((Book)getSelectedItem()).getIsbn();			
		}
		return null;
	}
	public void setIssn(String issn) {
		if (getSelectedItem() != null && getSelectedItem() instanceof Magazine) {
			((Magazine)getSelectedItem()).setIssn(issn);			
		}
	}
  public String getIssn() {
		if (getSelectedItem() == null) return null;
		if (getSelectedItem() instanceof Magazine) {
			return ((Magazine)getSelectedItem()).getIssn();			
		}
		return null;
	}
	public void setIssue(String issue) {
		if (getSelectedItem() != null && getSelectedItem() instanceof Magazine) {
			((Magazine)getSelectedItem()).setIssue(issue);			
		}
	}
  public String getIssue() {
		if (getSelectedItem() == null) return null;
		if (getSelectedItem() instanceof Magazine) {
			return ((Magazine)getSelectedItem()).getIssue();			
		}
		return null;
	}
  
  public String getItemType() {
		if (getSelectedItem() == null) return null;
		if (getSelectedItem() instanceof Magazine) {
			return "Magazine";
		} 
		return "Book";
  }
  public void setItemType() {}
}
