<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>

<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="https://ajax4jsf.dev.java.net/ajax" prefix="a4j"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
  <head>
    <meta http-equiv=content-type content="text/html; charset=iso-8859-1">
    <meta http-equiv="pragma" content="no-cache">
    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="content-language" content="de">
    <meta http-equiv="expires" content="0">

    <meta name="copyright" content="(c) Dr. Arndt Schnberg">
    <meta name="author" content="Dr. Arndt Schnberg">
    <meta name="language" content="deutsch, de">
    <meta name="page-topic" content="Bibliothek">
    <meta name="publisher" content="schnberg-solutions">
    <meta name="date" content="2007-06-01">
    <meta name="keywords" content="Demo Bibliothek">
    <meta name="description" content="Bibliothek">
    <title>Demo: Bibliothek</title>
  </head>
  <body>
     <f:view>
       <h:form id="mama_db"> 
         <h:outputText escape="false" rendered="true" converter="javax.faces.Character" value="<h1>Ergebnisse der Suche</h1>"></h:outputText>
         <h:panelGrid columns="2" id="guigrid" rendered="true">
           
            <h:panelGrid columns="1">
              <h:selectOneListbox title="Whlen sie ein Suchergebnis." size="17" value="#{libraryBackingBean.selectedItemID}" id="hits">
                <a4j:support event="onclick" action="#{libraryBackingBean.changeItem}" reRender="info,hits"/>
                <f:selectItems value="#{libraryBackingBean.hitsSelectItems}"/>
              </h:selectOneListbox>
            </h:panelGrid>
            
            <h:panelGrid columns="2" id="info">
               <h:outputLabel for="catalog">
                 <h:outputText value="Katalog:"></h:outputText>
               </h:outputLabel>
               <h:selectOneMenu id="catalog" converter="CatalogConverter" value="#{libraryBackingBean.catalog}" disabled="#{!libraryBackingBean.book && !libraryBackingBean.magazine}">
                 <f:selectItems value="#{libraryBackingBean.catalogSelectItems}" />
               </h:selectOneMenu>
               
               <h:outputLabel for="title">
                 <h:outputText value="Titel:"></h:outputText>
               </h:outputLabel>
               <h:inputTextarea id="title" rows="3" value="#{libraryBackingBean.title}" disabled="#{!libraryBackingBean.book && !libraryBackingBean.magazine}"></h:inputTextarea>
          
               <h:panelGroup></h:panelGroup>
               <h:selectOneRadio id="type" layout="lineDirection" value="#{libraryBackingBean.itemType}" disabled="true">
                 <f:selectItem itemValue="Book" itemLabel="Buch"/>
                 <f:selectItem itemValue="Magazine" itemLabel="Magazin"/>
               </h:selectOneRadio>
               
               <h:outputLabel for="author">
                 <h:outputText value="Autor:"></h:outputText>
               </h:outputLabel>
               <h:inputText id="author" value="#{libraryBackingBean.author}" disabled="#{!libraryBackingBean.book && !libraryBackingBean.magazine}"></h:inputText>
               
               <h:outputLabel for="isbn">
                 <h:outputText value="ISBN:"></h:outputText>
               </h:outputLabel>
               <h:inputText id="isbn" value="#{libraryBackingBean.isbn}" disabled="#{!libraryBackingBean.book}"></h:inputText>
               
               <h:outputLabel for="issn">
                 <h:outputText value="ISSN:"></h:outputText>
               </h:outputLabel>
               <h:inputText id="issn" value="#{libraryBackingBean.issn}" disabled="#{!libraryBackingBean.magazine}"></h:inputText>
          
               <h:outputLabel for="issue">
                 <h:outputText value="Ausgabe:"></h:outputText>
               </h:outputLabel>
               <h:inputText id="issue" value="#{libraryBackingBean.issue}"disabled="#{!libraryBackingBean.magazine}"></h:inputText>
            </h:panelGrid>
            
            <h:panelGroup> </h:panelGroup>
            <h:commandButton value="Zurck zur Suche" action="search"></h:commandButton>
    
            <h:panelGroup> </h:panelGroup>
            <h:messages></h:messages>
         </h:panelGrid>
        
        
       </h:form>
     </f:view>
   </body>
</html>
