package de.schoeso.application.web.library.swing.system;

import java.util.Collection;

import de.schoeso.application.web.library.entity.LibraryCatalog;
import de.schoeso.application.web.library.entity.LibraryItem;
import de.schoeso.application.web.library.swing.SwingLibraryHits;
import de.schoeso.application.web.library.swing.SwingLibraryItemDetails;
import de.schoeso.application.web.library.swing.SwingLibrarySearch;

/**
 * Controller fr das Zusammenspiel der GUI-Komponenten und den Zugriff auf die Geschftslogik
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */

public class SwingLibraryController {

	/** Zugriff auf die Geschftslogik */
	private FacadeSwingLibrary facade = new FacadeSwingLibrary();
	
	// Die verwalteten Komponenten
	SwingLibrarySearch swingLibrarySearch;
	SwingLibraryHits swingLibraryHits;
	SwingLibraryItemDetails swingLibraryDetails;
	
	public SwingLibraryController() {
	}
	// ========= Die zu verwaltenden Objekte dem bekannt machen
	public void setSwingLibraryDetails(SwingLibraryItemDetails swingLibraryDetails) {
		this.swingLibraryDetails = swingLibraryDetails;
	}
	public void setSwingLibraryHits(SwingLibraryHits swingLibraryHits) {
		this.swingLibraryHits = swingLibraryHits;
	}
	public void setSwingLibrarySearch(SwingLibrarySearch swingLibrarySearch) {
		this.swingLibrarySearch = swingLibrarySearch;
	}
	// =========================================================
	/** Wrapper fr die Methode in facede - Optiimierung mglich, da jetzt jedesmal auf die DB zugegriffen wird */
	public Collection<LibraryCatalog> getCatalogs() {
		return facade.getAllCatalogs();
	}	
	/** Startet die Suche in der Facade Klasse und setzt die Werte in der Ergebnisliste 
	 * @param titlesubstring zu suchender Teilstring
	 * @param catalog zu durchsuchender Katalog */
	public void getSearchItems(LibraryCatalog catalog, String titlesubstring) {
		Collection<LibraryItem> result = facade.searchItems(catalog, titlesubstring);
		swingLibraryHits.setData(result);
	}
  /** Es wurde ein Eintrag selektiert / nun die Details anyeigen */
	public void itemSelected(LibraryItem selectedValue) {
		swingLibraryDetails.setItem(selectedValue);
	}

	public void saveItem(LibraryItem actitem) {
		facade.saveItem(actitem);
	}
	
}
