package de.schoeso.application.web.library.swing;

import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JFrame;
import javax.swing.JPanel;

import de.schoeso.application.web.library.swing.system.SwingLibraryController;
/**
 * Buckatalog einer Bibliothek
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */

@SuppressWarnings("serial")
public class SwingStarter extends JFrame {

	private JPanel jContentPane = null;

	/** default constructor */
	public SwingStarter() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * @return void
	 */
	private void initialize() {
		this.setTitle("Demo: Bibliothek");

		this.setSize(new Dimension(900, 300));
		jContentPane = new JPanel();
		jContentPane.setLayout(new GridLayout(1, 0));
		
		SwingLibraryController swingLibraryGUIController = new SwingLibraryController();
		
		jContentPane.add(new SwingLibrarySearch(swingLibraryGUIController));
		jContentPane.add(new SwingLibraryHits(swingLibraryGUIController));
		jContentPane.add(new SwingLibraryItemDetails(swingLibraryGUIController));

		this.setContentPane(jContentPane);
	}


	/**
	 * @param args
	 */
	public static void main(String[] args) {
		new SwingStarter().setVisible(true);
		// Anbindungen zerstren!!!!
	}
}  //  @jve:decl-index=0:visual-constraint="10,10"
