package de.schoeso.application.web.library.swing;

import java.awt.Rectangle;
import java.util.Collection;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import de.schoeso.application.web.library.entity.Book;
import de.schoeso.application.web.library.entity.LibraryCatalog;
import de.schoeso.application.web.library.entity.LibraryItem;
import de.schoeso.application.web.library.entity.Magazine;
import de.schoeso.application.web.library.swing.system.SwingLibraryController;

/**
 * Detailanzeige / Eingabe eines Buches
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */

@SuppressWarnings("serial")
public class SwingLibraryItemDetails extends SwingLibraryGUIComponent {
	/** Aktuell dargestellte Item */
	private LibraryItem actitem = null;  //  @jve:decl-index=0:
	
	private JLabel labCatalog = null;
	private JComboBox ctaCombo = null;
	private JLabel labISBN;
	private JLabel labTitle;
	private JTextField isbn = null;
	private JTextArea title;
	private JLabel labAuthor;
	private JTextField author;
	private ButtonGroup ragiogroup = null;  //  @jve:decl-index=0:
	private JRadioButton radio1 = null;
	private JRadioButton radio2 = null;
	private JLabel labISSN;
	private JTextField issn;
	private JLabel labIssue;
	private JTextField issue;
	private JButton butSave = null;
	
	public SwingLibraryItemDetails(SwingLibraryController controller) {
		super(controller);
		controller.setSwingLibraryDetails(this);
		initialize();
		setEnabled(false);
	}

	// ==== GUI mit Builder erstellt
	private void initialize() {
		this.setSize(275, 213);
		this.setLayout(null);

		labCatalog = new JLabel();
		labCatalog.setText("Katalog:");
		labCatalog.setBounds(new Rectangle(1, 1, 81, 21));
		ctaCombo = new JComboBox();
		ctaCombo.setBounds(new Rectangle(85, 1, 188, 21));
		Collection<LibraryCatalog> cats = this.getSwingController().getCatalogs();
		for (LibraryCatalog cat : cats) { 
			ctaCombo.addItem(cat);
		}
		
		labTitle = new JLabel();
		labTitle.setText("Titel:");
		labTitle.setBounds(new Rectangle(1, 23, 81, 21));
		title = new JTextArea();
		title.setBounds(new Rectangle(85, 23, 188, 45));
		title.setLineWrap(true);     
		title.setWrapStyleWord(true);
    
		ragiogroup = new ButtonGroup();  
		radio1 = new JRadioButton("Buch");
		radio1.setBounds(new Rectangle(1, 67, 87, 21));
		radio2 = new JRadioButton("Zeitschrift");
		radio2.setBounds(new Rectangle(92, 67, 96, 21));
		ragiogroup.add(radio1);
		ragiogroup.add(radio2);
		
		labAuthor = new JLabel();
		labAuthor.setText("Autor:");
		labAuthor.setBounds(new Rectangle(1, 89, 81, 21));
		author = new JTextField();
		author.setBounds(new Rectangle(85, 89, 188, 21));		

		labISBN = new JLabel();
		labISBN.setText("ISBN:");
		labISBN.setBounds(new Rectangle(1, 111, 81, 21));
		isbn = new JTextField();
		isbn.setBounds(new Rectangle(85, 111, 188, 21));

		labISSN = new JLabel();
		labISSN.setText("ISSN:");
		labISSN.setBounds(new Rectangle(1, 133, 81, 21));
		issn = new JTextField();
		issn.setBounds(new Rectangle(85, 133, 188, 21));
		
		labIssue = new JLabel();
		labIssue.setText("Ausgabe:");
		labIssue.setBounds(new Rectangle(1, 155, 81, 21));
		issue = new JTextField();
		issue.setBounds(new Rectangle(85, 155, 188, 21));		

		butSave = new JButton();
		butSave.setBounds(new Rectangle(61, 185, 166, 22));
		butSave.setText("save");
		butSave.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				saveItem();
			}
		});
		
		this.add(labCatalog, null);
		this.add(ctaCombo, null);
		this.add(labTitle, null);
		this.add(title, null);
		this.add(labAuthor, null);
		this.add(author, null);
		this.add(radio1, null);
		this.add(radio2, null);
		this.add(labISBN, null);
		this.add(isbn, null);
		this.add(labISSN, null);
		this.add(issn, null);
		this.add(labIssue, null);
		this.add(issue, null);
		this.add(butSave, null);
	}
	
	public void setItem(LibraryItem item) {
		this.actitem = item;
		showItem(item);
	}
	
	/** Setzt die Werte im Objekt und stt die Sicherung an */ 
	private void saveItem() {
		if (actitem != null) {
			actitem.setTitle(title.getText());
			if (actitem instanceof Book) {
				((Book)actitem).setAuthor(author.getText());
				((Book)actitem).setIsbn(isbn.getText());
			} else {
				((Magazine)actitem).setIssue(issue.getText());
				((Magazine)actitem).setIssn(issn.getText());
			}
			this.getSwingController().saveItem(actitem);
		}
	}
	/** Zeigt das aktuelle Objekt in den Feldern an */
	private void showItem(LibraryItem item) {
		clearAll();
		this.setEnabled(true);
		if (item != null) {
			ctaCombo.setSelectedItem(item.getCatalog());
			title.setText(item.getTitle());
			if (item instanceof Book) {
				author.setText(((Book)item).getAuthor());
				isbn.setText(((Book)item).getIsbn());
				radio1.setSelected(true);
				issn.setEnabled(false);
				issue.setEnabled(false);
				labISSN.setEnabled(false);
				labIssue.setEnabled(false);
			} else {
				radio2.setSelected(true);
				issn.setText(((Magazine)item).getIssn());
				issue.setText(((Magazine)item).getIssue());
				isbn.setEnabled(false);
				author.setEnabled(false);
				labISBN.setEnabled(false);
				labAuthor.setEnabled(false);
			}
		}
	}
	/** Alle Inhalte lschen */
	private void clearAll() {
		ctaCombo.setSelectedIndex(-1);
		title.setText("");
		author.setText("");
		isbn.setText("");
		issn.setText("");
	}

	@Override
	public void setEnabled(boolean enabled) {
		boolean val = enabled && actitem != null;
		super.setEnabled(val);
		for (int i = 0; i < this.getComponentCount(); i++) {
			getComponents()[i].setEnabled(val);
		}
		radio1.setEnabled(false);
		radio2.setEnabled(false);
	}

}  //  @jve:decl-index=0:visual-constraint="10,13"
