package de.schoeso.application.web.library.facade;

import java.util.Collection;

import javax.ejb.Remote;

import de.schoeso.application.web.library.entity.LibraryCatalog;
import de.schoeso.application.web.library.entity.LibraryItem;

/**
 * allgemine Facade fr den Zugriff auf die Bibliothek - Remotinterface als POJI
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */
@Remote
public interface LibraryRemote {

	/** Sucht nach den Kriterien in den Katalogen 
	 * @param titlesubstring zu suchender Teilstring
	 * @param catalog zu durchsuchender Katalog */
	public Collection<LibraryItem> searchItems(LibraryCatalog catalog,
			String titlesubstring);

	/** Liefert alle Kataloge */
	public Collection<LibraryCatalog> getAllCatalogs();
	
	public Collection<LibraryItem> getLastSearchItems();
	
	public void saveItem(LibraryItem actitem);
	
}