package de.schoeso.application.web.library.facade;

import java.util.Collection;
import java.util.Vector;

import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;

import org.apache.log4j.Logger;

import de.schoeso.application.web.library.entity.LibraryCatalog;
import de.schoeso.application.web.library.entity.LibraryItem;

/**
 * allgemine Facade fr den Zugriff auf die Bibliothek
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */
@Stateful
public class LibraryBean implements LibraryRemote {
	 Logger log = Logger.getLogger(LibraryRemote.class);
	 /** Speichert die letzte Suche zwischen */
	private Vector<LibraryItem> lastSearch = new Vector<LibraryItem>();
//	/** aktuell bearbeitetes Item in der Collection */
//	private int lastSelitemId = -1;

  // Erweiterter Kontext fr autosave
	@PersistenceContext(type = PersistenceContextType.EXTENDED) 
  protected EntityManager em;
  
  public LibraryBean() {
  }

	/* (non-Javadoc)
	 * @see de.schoeso.application.web.library.facade.FacadeLibrarayInterface#searchItems(de.schoeso.application.web.library.entity.LibraryCatalog, java.lang.String)
	 */
	public Collection<LibraryItem> searchItems(LibraryCatalog catalog, String titlesubstring) {
		Vector<LibraryItem> co = new Vector<LibraryItem>();
		for (LibraryCatalog cat : getAllCatalogs()) {
			if (cat.equals(catalog)) {
			  co.addAll(cat.search(titlesubstring));
			}
		}
		lastSearch = co;
		return co;
	}
	public Vector<LibraryItem> getLastSearchItems() {
		return lastSearch;
	}
  /* (non-Javadoc)
	 * @see de.schoeso.application.web.library.facade.FacadeLibrarayInterface#getAllCatalogs()
	 */
	@SuppressWarnings("unchecked")
	public Collection<LibraryCatalog> getAllCatalogs() {
		Collection<LibraryCatalog> co = null;
		// Abfrage aller Kataloge
		Query q = em.createNamedQuery("getAllCatalogs"); 
		try {
		  co = q.getResultList();
		} catch (NoResultException nre) {
				if (log.isDebugEnabled())
					log.debug("Fehler in getAllCatalogs " + nre.getMessage());
			}
		return co;
	}	
	/** Sichert ein bergebenes LibraryItem-Objekt */
	public void saveItem(LibraryItem item) {
		try {
			if (item != null) {
			  em.merge(item); // fhrt das Update aus, die nderung ist auch in dem Sucherergebnis, da ein erweiterter Context vorliegt
			}
		} catch (OptimisticLockException e) {
			System.out.println("Es ist eine OptimisticLockException aufgetreten");
		}
	}
	// ============= Verwaltungsmethoden
	@Remove(retainIfException=false)
	public void remove() {
		em.close();
	}
}
