package de.schoeso.application.web.library.entity;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Version;
/**
 * Basisklasse der Verwalteten Objekte
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */

/* allocationSize legt fest wie viele auf einmal gelesen werden */ 
@Entity
@javax.persistence.SequenceGenerator(name="libitemseq", initialValue=1, sequenceName="libitemseq", allocationSize=1)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
public abstract class LibraryItem implements Serializable {

	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator="libitemseq")
	private long libitemid = 0;
	@Version
	private int version; // Version fr Optimisic Locking

	@ManyToOne
	private LibraryCatalog catalog; // Verweis auf den Katalog
	private String title;

	public LibraryItem() {
	}

	public long getLibitemid() {
		return this.libitemid;
	}

	public void setLibitemid(long libitemid) {
		this.libitemid = libitemid;
	}

	public int getVersion() {
		return version;
	}
	/** Wird nur fr das Optimistic Locking verwendet und darf nicht gelesen werden */
	@SuppressWarnings("unused")
	private void setVersion(int version) {
		this.version = version;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public LibraryCatalog getCatalog() {
		return catalog;
	}

	public void setCatalog(LibraryCatalog catalog) {
		this.catalog = catalog;
	}
  @Override
	public String toString() {
		return getTitle();
	}

	public int hashCode() {
		return (this.getLibitemid() == 0) ? 0 : new Long(getLibitemid()).hashCode();
	}

	public boolean equals(Object object) {
		if (object instanceof LibraryItem) {
			final LibraryItem obj = (LibraryItem) object;
			return obj.getLibitemid() == this.getLibitemid();
		}
		return false;
	}

}
